/***************************************************************************
 *   Copyright (C) 2005-2007 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef TOPLEVEL_UI_H
#define TOPLEVEL_UI_H

#include <tqtoolbutton.h>
#include <kdockwidget.h>
#include <tdeaction.h>

#include "common/gui/key_gui.h"
namespace Programmer { class Group; }
namespace Tool { class Group; }

//----------------------------------------------------------------------------
class ProgrammerStatusWidget : public TQObject, public KeyPopupButton<TQString>
{
Q_OBJECT
  
public:
  ProgrammerStatusWidget(TQWidget *parent);

signals:
  void configure();
  void selected(const Programmer::Group &group);

private slots:
  void activatedSlot(int id);
};

//----------------------------------------------------------------------------
class ToolStatusWidget : public TQObject, public KeyPopupButton<TQString>
{
Q_OBJECT
  
public:
  ToolStatusWidget(TQWidget *parent);

signals:
  void configureToolchain();
  void configure();
  void selected(const Tool::Group &group);

private slots:
  void activatedSlot(int id);
};

//----------------------------------------------------------------------------
class ViewMenuAction : public TDEToggleAction
{
Q_OBJECT
  
public:
  ViewMenuAction(KDockWidget *widget);

signals:
  void activated(TQWidget *);

private slots:
  virtual void slotActivated();

private:
  KDockWidget *_widget;
};

//----------------------------------------------------------------------------
class MenuBarButton : public TQToolButton
{
Q_OBJECT
  
public:
  MenuBarButton(const TQString &icon, TQWidget *parent);
  virtual TQSize sizeHint() const;
};

#endif
