/***************************************************************************
 *   Copyright (C) 2006-2007 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef MISC_GUI_H
#define MISC_GUI_H

#include <tqlayout.h>
#include <tqsplitter.h>
#include <tqvaluevector.h>
#include <tqvalidator.h>
#include <tqcombobox.h>
#include <tqwidgetstack.h>

#include <tdelocale.h>
#include <kpushbutton.h>
#include <ktabwidget.h>
#include <ktabbar.h>
#include <kstdguiitem.h>
#include <klineedit.h>
class TDEAction;

#include "common/global/generic_config.h"
#include "common/global/log.h"
#include "common/common/number.h"

//-----------------------------------------------------------------------------
class PBusyCursor
{
public:
  PBusyCursor() { start(); }
  ~PBusyCursor() { stop(); }
  static void start();
  static void stop();
  static void pause();
  static void restore();

private:
  static bool _overridePaused;
};

//-----------------------------------------------------------------------------
namespace MessageBox
{
extern void information(const TQString &text, Log::ShowMode show, const TQString &dontShowAgainName = TQString());
extern void detailedSorry(const TQString &text, const TQString &details, Log::ShowMode show);
inline void sorry(const TQString &text, Log::ShowMode show) { detailedSorry(text, TQString(), show); }
extern bool askContinue(const TQString &text, const KGuiItem &continueButton = KStdGuiItem::cont(),
                        const TQString &caption = i18n("Warning"));
extern bool questionYesNo(const TQString &text, const KGuiItem &yesButton, const KGuiItem &noButton,
                          const TQString &caption = i18n("Warning"));
enum Result { Yes, No, Cancel };
extern Result questionYesNoCancel(const TQString &text, const KGuiItem &yesButton, const KGuiItem &noButton,
                                  const TQString &caption = i18n("Warning"));
extern void text(const TQString &text, Log::ShowMode show);
}

//----------------------------------------------------------------------------
class PopupButton : public KPushButton
{
TQ_OBJECT
  
public:
  PopupButton(TQWidget *parent = 0, const char *name = 0);
  PopupButton(const TQString &text, TQWidget *parent = 0, const char *name = 0);
  void appendAction(TDEAction *action);
  void appendAction(const TQString &label, const TQString &icon = TQString(),
                    TQObject *receiver = 0, const char *slot = 0);
  int appendItem(const TQString &label, uint id) { return appendItem(label, TQPixmap(), id); }
  int appendItem(const TQString &label, const TQString &icon, int id = -1);
  int appendItem(const TQString &label, const TQPixmap &icon, int id = -1);
  void appendSeparator() { _separator = true; }

signals:
  void activated(int id);

private:
  bool _separator;

  void init();
};

//-----------------------------------------------------------------------------
class Splitter : public TQSplitter
{
TQ_OBJECT
  
public:
  Splitter(const TQValueList<int> &defaultSizes, Qt::Orientation orientation,
           TQWidget *parent, const char *name);
  virtual ~Splitter();

private slots:
  void updateSizes();

private:
  TQValueList<int> _defaultSizes;
};

//-----------------------------------------------------------------------------
class GuiConfig : public GenericConfig
{
public:
  GuiConfig() : GenericConfig("gui") {}
};

//-----------------------------------------------------------------------------
class SeparatorWidget : public TQFrame
{
TQ_OBJECT
  
public:
  SeparatorWidget(TQWidget *parent) : TQFrame(parent, "separator") {
    setFrameStyle(TQFrame::Panel | TQFrame::Sunken);
    setMargin(2);
    setFixedHeight(2*2);
  }
};

//-----------------------------------------------------------------------------
class TabBar : public KTabBar
{
TQ_OBJECT
  
public:
  TabBar(TQWidget *parent = 0, const char *name = 0);

protected:
  virtual void wheelEvent(TQWheelEvent *e);

private:
  bool _ignoreWheelEvent;

  friend class TabWidget;
};

class TabWidget : public KTabWidget
{
TQ_OBJECT
  
public:
  TabWidget(TQWidget *parent = 0, const char *name = 0);
  void setIgnoreWheelEvent(bool ignore);

protected:
  virtual void wheelEvent(TQWheelEvent *e);
  void setTabBar(TabBar *tabbar);
};

//-----------------------------------------------------------------------------
class ComboBox : public TQComboBox
{
TQ_OBJECT
  
public:
  ComboBox(TQWidget *parent = 0, const char *name = 0);
  void setIgnoreWheelEvent(bool ignore) { _ignoreWheelEvent = ignore; }

protected:
  virtual void wheelEvent(TQWheelEvent *e);

private:
  bool _ignoreWheelEvent;
};

#endif
