/***************************************************************************
 *   Copyright (C) 2005-2007 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "cli_log.h"

#include "common/global/global.h"
#include "cli_global.h"

void CLI::View::doLog(Log::LineType type, const TQString &text, Log::Action)
{
  TQString s = text + "\n";
  switch (type.type()) {
    case Log::LineType::Error:
    case Log::LineType::SoftError: s = "Error: " + s; break;
    case Log::LineType::Warning: s = "Warning: " + s; break;
    default: break;
  }
  if ( type==Log::LineType::Error || type==Log::LineType::SoftError ) fprintf(stderr, "%s", s.latin1());
  else fprintf(stdout, "%s", s.latin1());
}

void CLI::View::doLog(Log::DebugLevel, const TQString &text, Log::Action)
{
  TQString s = text + "\n";
  fprintf(stdout, "%s", s.latin1());
}

void CLI::View::appendToLastLine(const TQString &text)
{
  fprintf(stdout, "%s", text.latin1());
}

void CLI::View::sorry(const TQString &message, const TQString &details)
{
  if ( details.isEmpty() ) log(Log::LineType::Error, message, Log::Immediate);
  else log(Log::LineType::Error, message + " (" + details + ")", Log::Immediate);
}

bool CLI::View::askContinue(const TQString &message)
{
  log(Log::LineType::Warning, message + " " + (_force ? i18n("*yes*") : i18n("*no*")), Log::Immediate);
  if (_force) return true;
  if ( !_isInteractive ) return false; // always fail
  // #### TODO
  return false;
}

void CLI::View::logUserAbort()
{
  if ( !_isInteractive ) return;
  return;
  //Log::View::logUserAbort();
}
