/***************************************************************************
 *   Copyright (C) 2007 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "tbl_bootloader_ui.h"

#include "progs/tbl_bootloader/base/tbl_bootloader.h"
#include "common/port/serial.h"

//-----------------------------------------------------------------------------
TinyBootloader::ConfigWidget::ConfigWidget(const::Programmer::Group &group, TQWidget *parent)
  : ::Programmer::ConfigWidget(group, parent)
{
  uint row = numRows();

  TQLabel *label = new TQLabel(i18n("Port Speed:"), this);
  addWidget(label, row,row, 0,0);
  _speed = new KComboBox(this);
  for (uint i=0; i<Port::Serial::Nb_Speeds; i++) {
    if ( Port::Serial::SPEED_VALUES[i]==0 || !Port::Serial::SPEED_DATA[i].supported ) continue;
    _speed->insertItem(TQString::number(Port::Serial::SPEED_VALUES[i]));
  }
  addWidget(_speed, row,row, 1,1);
  row++;

  label = new TQLabel(i18n("Timeout (ms):"), this);
  addWidget(label, row,row, 0,0);
  _timeout = new KIntNumInput(this);
  _timeout->setMinValue(0);
  addWidget(_timeout, row,row, 1,1);
  row++;

  label = new TQLabel(i18n("No of Retries:"), this);
  addWidget(label, row,row, 0,0);
  _retries = new KIntNumInput(this);
  _retries->setMinValue(0);
  addWidget(_retries, row,row, 1,1);
  row++;
}

void TinyBootloader::ConfigWidget::saveConfig()
{
  Config config;
  uint k = 0;
  for (uint i=0; i<Port::Serial::Nb_Speeds; i++) {
    if ( Port::Serial::SPEED_VALUES[i]==0 || !Port::Serial::SPEED_DATA[i].supported ) continue;
    if ( uint(_speed->currentItem())==k ) {
      config.writeSpeed(Port::Serial::Speed(i));
      break;
    }
    k++;
  }
  config.writeTimeout(_timeout->value());
  config.writeRetries(_retries->value());
}

void TinyBootloader::ConfigWidget::loadConfig()
{
  Config config;
  Port::Serial::Speed speed = config.readSpeed();
  uint k = 0;
  for (uint i=0; i<Port::Serial::Nb_Speeds; i++) {
    if ( Port::Serial::SPEED_VALUES[i]==0 || !Port::Serial::SPEED_DATA[i].supported ) continue;
    if ( i==uint(speed) ) break;
    k++;
  }
  _speed->setCurrentItem(k);
  _timeout->setValue(config.readTimeout());
  _retries->setValue(config.readRetries());
}

//-----------------------------------------------------------------------------
::Programmer::ConfigWidget *TinyBootloader::GroupUI::createConfigWidget(TQWidget *parent) const
{
  return new ConfigWidget(static_cast<const ::Programmer::Group &>(group()), parent);
}

#include "tbl_bootloader_ui.moc"
