/***************************************************************************
 *   Copyright (C) 2005 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef PORT_SELECTOR_H
#define PORT_SELECTOR_H

#include <tqradiobutton.h>
#include <tqcombobox.h>
#include <tqlayout.h>
#include <tqbuttongroup.h>
#include <tqlabel.h>

#include "common/port/port.h"
namespace Programmer { class Group; }

class PortSelector : public TQFrame
{
  TQ_OBJECT
  
public:
  PortSelector(TQWidget *parent);
  void setGroup(const Programmer::Group &group);
  Port::Description portDescription() const { return Port::Description(type(), device(type())); }
  void saveConfig();
  void setStatus(PortType type, const TQString &message);

signals:
  void changed();

private slots:
  void textChanged();

private:
  const Programmer::Group *_group;
  TQGridLayout  *_top, *_grid;
  TQWidget      *_main;
  TQButtonGroup *_bgroup;
  TQComboBox    *_combos[PortType::Nb_Types];
  TQLabel       *_status[PortType::Nb_Types];
  bool          _pending;
  static const char * const LABELS[PortType::Nb_Types];

  void addPortType(const Port::Description &pd);
  PortType type() const;
  TQString device(PortType type) const;
};

#endif
