#!/usr/bin/env python

"""**************************************************************************
** $Id: fontdisplayer.py,v 1.2 2004/07/19 18:41:53 phil Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for TQt.  This example
** program may be used, distributed and modified without limitation.
**
***************************************************************************"""

import sys
from PyTQt.tqt import *

class FontRowTable( TQFrame ):
    def __init__( self, parent=None, name=None ):
        TQFrame.__init__( self, parent, name )

        self.setBackgroundMode(self.PaletteBase)
        self.setFrameStyle(self.Panel|self.Sunken)
        self.setMargin(8)
        self.setRow(0)
        self.row = 0
        self.tablefont = TQFont( TQApplication.font() )

    def sizeHint( self ) :
        width  = 16*self.cellSize().width()+TQSize(2,2).width()*(self.margin()+self.frameWidth())
        height = 16*self.cellSize().height()+TQSize(2,2).height()*(self.margin()+self.frameWidth())
        return TQSize(width,height)
        
    def cellSize( self ) :
        fm = self.fontMetrics()
        return TQSize( fm.maxWidth(), fm.lineSpacing() + 1 )
    
    def paintEvent( self, e ):
        TQFrame.paintEvent(self, e)
        p = TQPainter(self)
        p.setClipRegion(e.region())
        r = TQRect(e.rect())
        fm = self.fontMetrics()
        ml = self.frameWidth() + self.margin() + 1 + max(0,-fm.minLeftBearing())
        mt = self.frameWidth() + self.margin()
        cell = TQSize(int((self.width()-15-ml)/16),int((self.height()-15-mt)/16))

        if not cell.width() or not cell.height() :
            return

        mini = int(r.left() / cell.width())
        maxi = int((r.right()+cell.width()-1) / cell.width())
        minj = int(r.top() / cell.height())
        maxj = int((r.bottom()+cell.height()-1) / cell.height())

        h = fm.height()

        body      = TQColor(255,255,192);
        negative  = TQColor(255,192,192);
        positive  = TQColor(192,192,255);
        rnegative = TQColor(255,128,128);
        rpositive = TQColor(128,128,255);

        for j in range(minj, maxj+1, 1) :
            for i in range(mini, maxi+1, 1) :
                if i < 16 and j < 16 :
                    x = i*cell.width()
                    y = j*cell.height()

                    ch = TQChar(j*16+i) #,self.row) # just accept one argument!!!

                    if fm.inFont(ch) :
                        w = fm.width(ch)
                        l = fm.leftBearing(ch)
                        r = fm.rightBearing(ch)

                        x += ml
                        y += mt+h

                        p.fillRect(x,y,w,-h,TQBrush(body))
                        
                        if w :
                            if l :
                                if l < 0: sign = negative
                                else: sign = positive
                                if l > 0: lsign = 0
                                else: lsign = 1
                                p.fillRect(x+lsign, int(y-h/2), abs(l),int(-h/2), TQBrush(sign))
                            if r :
                                if r < 0: sign = rnegative
                                else: sign = rpositive
                                if r > 0: rsign = r
                                else: rsign = 0
                                p.fillRect(int(x+w-rsign),y+2, abs(r),int(-h/2), TQBrush(sign))
                        s = TQString( ch )
                        p.setPen(TQPen(TQt.black))
                        p.drawText(x,y,s)
    
    def setRow( self, r ) :
        self.row = r

        fm = self.fontMetrics()
        str = " minLB=%d minRB=%d maxW=%d" % (fm.minLeftBearing(), fm.minRightBearing(), fm.maxWidth())
        self.emit( PYSIGNAL("fontInformation"), ( TQString(str), ) )
        self.update()
        
    def chooseFont( self ) :
        ok = 0
        oldfont = TQFont( self.tablefont )
        self.tablefont, ok = TQFontDialog.getFont(oldfont, self)
        if ok:
            self.setFont(self.tablefont)
        else:
            self.tablefont = oldfont

class FontDisplayer( TQMainWindow ) :
    def __init__( self, parent=None, name=None ):
        TQMainWindow.__init__( self, parent, name )
        table = FontRowTable(self)
        controls = TQToolBar(self)
        
        TQLabel(self.tr("Row:"), controls)
        self.row = TQSpinBox(0,255,1,controls)
        controls.addSeparator()
        fontbutton = TQPushButton(self.tr("Font..."), controls)
        status = TQStatusBar(self) 
        
        self.connect( self.row, SIGNAL("valueChanged(int)"), table.setRow )
        self.connect( fontbutton, SIGNAL("clicked()"), table.chooseFont )
        self.connect( table, PYSIGNAL("fontInformation"),
                      status, SLOT("message(const TQString&)") )
        table.setRow(0)
        self.setCentralWidget(table)

def main( args ):
    # Use an interesting font
    TQApplication.setFont(TQFont("unifont",16))
    app = TQApplication(sys.argv)
    
    m = FontDisplayer()
    sh = TQSize( m.centralWidget().sizeHint() )
    m.resize(sh.width(), sh.height() + 3 * m.statusBar().height())
    app.setMainWidget(m);
    m.setCaption("TQt Example - TQFD");
    m.show()
    
    app.exec_loop()
    
if __name__=="__main__":
    main(sys.argv)
