/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATEINSERTMATRIXVECTORDIALOG_H
#define QALCULATEINSERTMATRIXVECTORDIALOG_H

#include <kdialogbase.h>

class TQTable;
class TQLabel;
class TQSpinBox;
class TQRadioButton;
class KComboBox;
class KLineEdit;
class TQPushButton;
class MathStructure;
class QalculateEditNamesDialog;
class KnownVariable;

/**
@author Niklas Knutsson
*/
class QalculateInsertMatrixVectorDialog : public KDialogBase {

	TQ_OBJECT

public:

	QalculateInsertMatrixVectorDialog(TQWidget *parent = 0, const char *name = 0);
	virtual ~QalculateInsertMatrixVectorDialog();

	TQString newMatrix();
	TQString newVector();
	TQString editMatrixVector(const MathStructure *initial_value = NULL, bool create_vector = false, bool is_text_struct = false, bool is_result = false);

	TQLabel *elementsLabel;
	TQRadioButton *matrixButton, *vectorButton;
	TQTable *elementsTable;
	TQSpinBox *rowsBox, *columnsBox;
	TQString matrixstr;
	TQPushButton *insertSelectionButton;

public slots:

	void typeChanged(int);
	void rowsChanged(int);
	void columnsChanged(int);
	void onSelectionChanged();
	
protected slots:
	
	void slotOk();
	void insertSelection();

};

#endif
