#ifndef COLORPICKER_H
#define COLORPICKER_H

#include <tqgroupbox.h>

class KIntNumInput;
class TQColor;

class ColorPicker : public TQGroupBox
{
    Q_OBJECT

public:
    ColorPicker( TQWidget* parent = 0, const char* name = 0);
    ~ColorPicker();
    TQColor & color();

public slots:
    void setColor(const TQColor & color);
    void setRed(int red);
   void emitChange();
    void setGreen(int green);
    void setBlue(int blue);
    void reset();
    void init();
    
protected:
   KIntNumInput *red;
   KIntNumInput *green;
   KIntNumInput *blue;
   TQColor color_;
   TQColor color__;

signals:
    void colorChanged(TQColor color);

};

#endif // COLORPICKER_H
