#ifndef __LIQUID_STYLE_H
#define __LIQUID_STYLE_H

#include <tqcstring.h>
#include <tqdir.h>
#include <tqintdict.h>
#include <tqprogressbar.h>
#include <tqtimer.h>
#include <tqwmatrix.h>
#include <kpixmap.h>
#include <tqwidget.h>
#include <tdestyle.h>

// #define BITMAP_ITEMS 75 // Don't worry, they're demand loaded ;-)
#define LIQUID_MENU_CHANGE 667
#define MOSFET_BUTTON_CHANGE 661

class TQColor;
class TQHeader;
class TQImage;
class TQMenuBar;
class TQPalette;
class TQPoint;
class TQPushButton;
class TQRect;
class TQScrollBar;
class TQSize;
class TQString;
class TQTabBar;
class LiquidStyle;

enum BitmapData{RadioOn = 0, RadioOff, RadioOnHover, RadioOffHover, RadioOnPressed, RadioOffPressed,
		VSBSliderTop, VSBSliderMid, VSBSliderBtm,
		VSBSliderTopActive, VSBSliderMidActive, VSBSliderBtmActive,
		VSBSliderTopPressed, VSBSliderMidPressed, VSBSliderBtmPressed,
		VSBSliderTopBg, VSBSliderMidBg, VSBSliderMidBgI, VSBSliderBtmBg,
                HSBSliderTop, HSBSliderMid, HSBSliderBtm,
		HSBSliderTopActive, HSBSliderMidActive, HSBSliderBtmActive,
		HSBSliderTopPressed, HSBSliderMidPressed, HSBSliderBtmPressed,
		HSBSliderTopBg, HSBSliderMidBg, HSBSliderMidBgI, HSBSliderBtmBg,
		Tab, TabDown, TabFocus, belowTab, belowTabDown,
		ButtonShadow, CB, CBDown, CBTri, CBHover, CBDownHover, CBTriHover, CBPressed, CBDownPressed, CBTriPressed,
		HSlider, VSlider, VSliderAbove, HSliderInactive, VSliderInactive, VSliderAboveInactive,
		Progress, rectbutton, combo, comboShadow, progress2, TitleBar, BITMAP_ITEMS};

enum CustomColor{CustomCBOn = 0, CustomCBOff, CustomRadioOn, CustomRadioOff,
                 CustomTabOn, CustomTabOff, CustomSBSlider, CustomSBSliderHover, CustomSBSliderPressed, CustomSBGroove};

enum PulseType{PushButton, ComboBox, AppletHandle, Splitter, ToolButton};

enum MenuBackground{Standard=0, Plain, Stipples, Gradient};

enum InactiveButtonColor{Original=0, Background, Active, Custom};

enum myExpanderStyle{Apple=0, MS};

enum progressStyle{mac=0, liquid, baghira};

enum DotlineStyle{Line=0, Dots};

enum Tile{TileTopLeft = 0, TileTop, TileTopRight,
          TileLeft, TileMiddle, TileRight, TileBtmLeft, TileBtm, TileBtmRight};

enum myPosition{left = 0, center, right, full};

enum tabStyle {TrueTab = 0, Clever, Chooser};

enum Style {Jaguar = 0, Panther, Brushed, Tiger, Milk, NUMSTYLES };

class ButtonTile
    {
    public:
    ButtonTile()
        {
        for ( int i = 0;i < 9;++i )
            pixmaps[ i ] = 0;
        }
    ~ButtonTile()
        {
        for ( int i = 0;i < 9;++i )
            if ( pixmaps[ i ] ) delete pixmaps[ i ];
        }
    TQPixmap* pixmap( Tile pos )
        {
        return ( pixmaps[ ( int ) pos ] );
        }
    void setPixmap( Tile pos, TQPixmap *pix )
        {
        pixmaps[ ( int ) pos ] = pix;
        }
    protected:
            TQPixmap *pixmaps[ 9 ];
    };


class OptionHandler : public TQObject
{
   Q_OBJECT
public:
   OptionHandler( TQObject *parent );
   void reloadSettings();
   inline static bool useShadowText()
   {
      return ( shadowText );
   }
   const TQColor& textColor();
   const TQColor& bgColor();
   const TQColor& buttonColor();
   static int custCols[8];

   inline void reset()
   {
      menusProcessed = false;
   }

   inline static bool glossyMenus()
   {
      return glossyMenus_;
   }

   inline static bool drawMenuStripe()
   {
      return (drawMenuStripe_);
   }

   inline static TQColor menuStripeColor()
   {
      return menuStripeColor_;
   }

   inline static TQColor textColorHigh()
   {
      return fgColorHigh;
   }

   inline static TQColor menuColorHigh()
   {
      return colorHigh;
   }

   inline static bool bevelHighlights()
   {
      return (bevelHighlights_);
   }
   inline static bool useBgStipple()
   {
      return ( bgStipple );
   }
   inline static Style style()
   {
      return (style_);
   }
   inline static int stippleContrast()
   {
      return ( contrast );
   }
   inline static bool useReverseBtnColor()
   {
      return ( reverseBtnColor );
   }
   inline static bool useToolButtonFrame()
   {
      return ( tbFrame );
   }

   inline static bool useCustomColors()
   {
      return ( customWidgetColor );
   }
   inline static const TQColor& customColor( int idx )
   {
      return ( customColors[ idx ] );
   }

   inline static bool DrawDotlines()
   {
      return ( drawDotlines );
   }
   inline static bool squeezeSbSlider()
   {
      return ( squeezesbslider );
   }
   inline static bool shadowSbSlider()
   {
      return (shadowsbslider);
   }
   inline static bool drawGroupBoxShadow()
   {
      return ( groupboxshadow );
   }
   inline static int ShadowDarkness()
   {
      return ( shadowDarkness );
   }
   inline static int InactiveButtonColorType()
   {
      return ( inactiveButtonColor );
   }
   inline static int MenuBackground()
   {
      return (menuBackground);
   }
   inline static int MenuOpacity()
   {
      return (menuOpacity);
   }
   inline static bool UseCustomMenuColor()
   {
      return (useCustomMenuColor);
   }
   inline static int DotlineStyle()
   {
      return (dotlineStyle);
   }
   inline static bool MenuColorButton()
   {
      return (menuColorButton);
   }
   inline static int ExpanderStyle()
   {
      return (expanderStyle);
   }
   inline static bool UseCustomExpanderColor()
   {
      return (useCustomExpanderColor);
   }
   inline static TQColor CustomExpanderColor()
   {
      return (expanderColor);
   }
   inline static TQColor DotlineColor()
   {
      return (dotlineColor);
   }
   inline TQColor InactiveButtonColor()
   {
      switch (inactiveButtonColor)
      {
      default:
      case 0 : return (TQColor(232,232,232));
      case 1 : return (bgColor());
      case 2 : return (buttonColor());
      case 3 : return (customInactiveButtonColor);
      }
   }
   inline static bool CenterTabs()
   {
      return centerTabs;
   }

   inline static bool SmoothListViewHeaders()
   {
      return smoothListViewHeaders;
   }

   inline static bool SmootherLVH()
   {
      return smootherLVH;
   }

   inline static bool IcyButtons()
   {
      return icyButtons;
   }

   inline static Style buttonStyle()
   {
      return _buttonStyle;
   }

   inline static int ProgressBar()
   {
      return progressBar;
   }

   inline static bool RemoveKickerBevel()
   {
      return removeKickerBevel;
   }

   inline static Style toolbuttonStyle()
   {
      return _toolbuttonStyle;
   }

   inline void setGroupShadowButton()
   {
      groupShadowButton = true;
   }
   inline void setNotGroupShadowButton()
   {
      groupShadowButton = false;
   }
   inline bool GroupShadowButton()
   {
      return groupShadowButton;
   }

   inline void setScrollerActive()
   {
      scrollerActive = true;
   }

   inline void setScrollerInactive()
   {
      scrollerActive = false;
   }

   inline bool ScrollerActive()
   {
      return scrollerActive;
   }

   inline static TQColor Color()
   {
      return color;
   }

   inline static TQColor Color2()
   {
      return color2;
   }

   inline static bool DrawProgressLabel()
   {
      return drawProgressLabel;
   }

   inline static tabStyle TabStyle()
   {
      return tabStyle_;
   }

   inline static TQColor & BrushTint()
   {
      return brushTint;
   }

   inline static bool TintBrush()
   {
      return tintBrush;
   }

   inline static bool AnimateSlider()
   {
      return animateSlider;
   }
   inline static bool AnimateProgress()
   {
      return animateProgress;
   }
   inline static TQColor CustomButtonColor()
   {
      return customButtonColor;
   }

   inline static bool AnimateButton()
   {
      return animateButton;
   }

   inline static TQColor aDecoColor1()
   {
      return aDecoColor1_;
   }
   inline static TQColor aDecoColor2()
   {
      return aDecoColor2_;
   }
   inline static TQColor titleColor( int i )
   {
      return titleColor_[i];
   }
   inline static TQColor titleButtonColor( int i )
   {
      return titleButtonColor_[i];
   }

   TQMenuBar *currentMenu;
   TQPixmap *indicatedMenuItemPix;
   TQRect *indicatedMenuItemRect;
   TQPixmap *lastIndicatedMenuItemPix;
   TQRect *lastIndicatedMenuItemRect;
   bool mouseOverMenu;
   WId lastIndicatedMenuItemID;
   static unsigned long wmDesign;


public slots:
   inline void warningSlot()
   {
      tqWarning("widget destroyed");
   }

protected:
   static TQColor titleColor_[2];
   static TQColor titleButtonColor_[3];

   // menu
   static int menuBackground;
   static int menuOpacity;
   static bool menuColorButton;
   static bool animateButton;
   static bool shadowText;
   static bool drawMenuStripe_;
   static TQColor menuStripeColor_;
   static bool glossyMenus_;
   //color
   static TQColor customButtonColor;
   //widgets
   static bool customWidgetColor;
   static TQColor customColors[ 10 ];
   //menu
   static bool useCustomMenuColor;
   static TQColor color, color2, colorHigh, fgColor, fgColorHigh;
   //incativeButton
   static int inactiveButtonColor;
   static TQColor customInactiveButtonColor;

   //Design
   //stipples
   static bool bgStipple, bevelHighlights_;
   static Style style_;
   static int contrast;
   //shadows
   static bool groupboxshadow;
   static int shadowDarkness;
   //istviews;
   static bool drawDotlines, useCustomExpanderColor;
   static int expanderStyle;
   static TQColor expanderColor, dotlineColor;
   static int dotlineStyle;
   //slider
   static bool squeezesbslider;
   static bool shadowsbslider;
   //toolbar
   static bool reverseBtnColor, tbFrame;
   //tweaks
   static bool centerTabs;
   static bool smoothListViewHeaders;
   static bool smootherLVH;
   static bool icyButtons;
   static Style _buttonStyle;
   bool menusProcessed;
   bool scrollerActive;
   int menuLevelCounter;
   bool groupShadowButton;
   static int progressBar;
   static bool removeKickerBevel;
   static Style _toolbuttonStyle;
   static bool drawProgressLabel;
   static tabStyle tabStyle_;

   TQString colorStr, fgColorStr/*, panelColorStr*/;
   static TQColor brushTint;
   static TQColor aDecoColor1_;
   static TQColor aDecoColor2_;
   static bool tintBrush;
   static bool animateSlider;
   static bool animateProgress;
};

class EventKiller : public TQObject
{
   Q_OBJECT
public:
   bool eventFilter( TQObject *, TQEvent *)
   {
      return TRUE;
   }
};

class BMShower : public TQObject
{
   Q_OBJECT
public:
   BMShower(TQObject *parent);
   bool eventFilter( TQObject *object, TQEvent *event );
};

class ButtonFadeInfo
{
public:
   ButtonFadeInfo()
   {
   timerId=0; index=0; fadeIn=TRUE;
   }
public:
   int timerId;
   int index;
   bool fadeIn;
};

class LiquidStyle : public TDEStyle
{
   Q_OBJECT
public:
   friend class OptionHandler;
   LiquidStyle();
   virtual ~LiquidStyle();
   bool isPlain() const;

   virtual void polish( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void * );
//                 virtual void polishPopupMenu( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, TQPopupMenu *w );
   virtual void unPolish( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void * );
   virtual void polish( TQPalette &p );
   virtual void applicationUnPolish( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void * );
   int styleHint(StyleHint,
                 const TQStyleControlElementData &ceData,
                 ControlElementFlags elementFlags,
                 const TQStyleOption & opt,
                 TQStyleHintReturn * shr,
                 const TQWidget * = 0) const;
   void drawTDEStylePrimitive( TDEStylePrimitive kpe,
                               TQPainter* p,
                               const TQStyleControlElementData &ceData,
                               ControlElementFlags elementFlags,
                               const TQRect &r,
                               const TQColorGroup &cg,
                               SFlags flags = Style_Default,
                               const TQStyleOption& = TQStyleOption::Default,
                               const TQWidget* widget = 0 ) const;
   void drawPrimitive( PrimitiveElement pe,
                       TQPainter* p,
                       const TQStyleControlElementData &ceData,
                       ControlElementFlags elementFlags,
                       const TQRect &r,
                       const TQColorGroup &cg,
                       SFlags flags = Style_Default,
                       const TQStyleOption& = TQStyleOption::Default ) const;
   void drawControl( ControlElement element,
                     TQPainter *p,
                     const TQStyleControlElementData &ceData,
                     ControlElementFlags elementFlags,
                     const TQRect &r,
                     const TQColorGroup &cg,
                     SFlags flags = Style_Default,
                     const TQStyleOption& = TQStyleOption::Default,
                     const TQWidget *widget = 0 ) const;
//		void drawControlMask( ControlElement element, TQPainter *p, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQRect &r, const TQStyleOption& = TQStyleOption::Default, const TQWidget *widget = 0 ) const;
   void drawComplexControl( ComplexControl control,
                            TQPainter *p,
                            const TQStyleControlElementData &ceData,
                            ControlElementFlags elementFlags,
                            const TQRect &r,
                            const TQColorGroup &cg,
                            SFlags flags = Style_Default,
                            SCFlags controls = SC_All,
                            SCFlags active = SC_None,
                            const TQStyleOption& = TQStyleOption::Default,
                            const TQWidget *widget = 0 ) const;
//		void drawComplexControlMask( ComplexControl control, TQPainter *p, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQRect &r, const TQStyleOption& = TQStyleOption::Default, const TQWidget *widget =0 ) const;

   int pixelMetric( PixelMetric m,
                    const TQStyleControlElementData &ceData,
                    ControlElementFlags elementFlags,
                    const TQWidget *widget = 0 ) const;

   TQSize sizeFromContents( ContentsType contents,
                            const TQStyleControlElementData &ceData,
                            ControlElementFlags elementFlags,
                            const TQSize &contentSize,
                            const TQStyleOption& opt,
                            const TQWidget *widget = 0 ) const;
   TQRect subRect( SubRect r,
                   const TQStyleControlElementData &ceData,
                   ControlElementFlags elementFlags,
                   const TQWidget *widget ) const;
   TQRect querySubControlMetrics( ComplexControl control,
                                  const TQStyleControlElementData &ceData,
                                  ControlElementFlags elementFlags,
                                  SubControl subcontrol,
                                  const TQStyleOption &opt = TQStyleOption::Default,
                                  const TQWidget *widget = 0 ) const;
   // Fix TQt3's wacky image positions
   TQPixmap stylePixmap( StylePixmap stylepixmap,
                         const TQStyleControlElementData &ceData,
                         ControlElementFlags elementFlags,
                         const TQStyleOption& = TQStyleOption::Default,
                         const TQWidget *widget = 0 ) const;
   virtual bool objectEventHandler( const TQStyleControlElementData &ceData,
                                    ControlElementFlags elementFlags,
                                    void* source,
                                    TQEvent *ev );

private slots:
   void updateProgressPos();
   void updateSliderPos();
   void progressBarDestroyed(TQObject*);
   void fakeMouse();

protected:
   void clearImage( TQImage &img ) const;
   ButtonTile* createButtonTile( const TQColor &c, const TQColor &bgColor, TQImage *buttonImage, TQImage *shadowImage, TQImage *glowImage, TQIntDict <ButtonTile>*buttonDict, TQIntDict<ButtonTile>*shadowDict, TQIntDict<ButtonTile>*glowDict, int w, int h, int xOff, int yOff, int centerW, int centerH, int shadowH, int glowWH, bool sunken) const;
   ButtonTile* createRoundFrameTile(TQImage &img, const TQColor &color, const TQColor *bg, const TQColor &baseColor ) const;
   TQPixmap* createSliderEnd( const TQColor &c, const TQColor &bgColor, bool top/*, bool vertical*/ ) const;
   ButtonTile* separateTiles( TQPixmap *pix, int xO, int yO, int w, int h, int sh, bool sunken) const;

   TQPixmap* getPixmap( BitmapData item ) const;
   TQPixmap* adjustHSV( TQImage &img, const TQColor &c, const TQColor *bg = NULL ) const;
   TQImage* adjustHSVImage( TQImage &img, const TQColor &c, const TQColor *bg = NULL ) const;
   void adjustHSV( TQPixmap &pix, const TQColor &c ) const;
   TQImage* tintBrush( const TQImage &img, const TQColor &c ) const;
   TQPixmap* processEmbedded( const char *label, const TQColor &c, bool blend = false, const TQColor *bg = NULL ) const;
   void drawRoundButton( TQPainter *p, const TQColorGroup &cg, const TQColor &c, /*const TQColor &bg,*/ int x, int y, int w, int h, bool pushedDown = false, bool hover = false, int bgX = -1, int bgY = -1) const;
   void drawRectangularButton( TQPainter *p, const TQColorGroup &cg, const TQColor &c, int x, int y, int w, int h, bool sunken = false, bool hover = false, bool isCombo = false, int position = full, bool isHtml = false) const;
   void drawCombo( TQPainter *painter, const TQColorGroup &cg, const TQColor &c, int x, int y, int w, int h, bool sunken, bool hover, bool isCombo, int position = full, bool isHTML = false ) const;
   void drawEditFrame( TQPainter *p, const TQRect &r, const TQColorGroup &cg, bool isHTML = false, bool focused = false, bool inverse = false/*, bool round = false*/ ) const;
   void drawRoundFrame( TQPainter *p, const TQRect &r, const TQColorGroup &cg, bool focused, TQPoint offset ) const;
   void drawHTMLCBBorder( const TQPixmap &pix, const TQColor &c ) const;
   bool isHTMLWidget( const TQWidget *w ) const;


private:
   LiquidStyle( const LiquidStyle & );
   LiquidStyle& operator=( const LiquidStyle & );
   int getBrightness(unsigned int rgb) const;
   TQImage fetchImage( const char *name );
   TQColor mapFadeColor(TQColor &color, int index) const;
   void fadeIn(TQPushButton *button);
   void fadeOut(TQPushButton *button);
   TQColor brushedMetalColor(TQColor &c) const;
   TQColor originalBgColor;


   TQBitmap *sbLeft, *sbRight, *sbUp, *sbDown, *checkmark;
   TQImage *btnBorderImg, *btnShadowImg, *slider_top, *slider_btm, *slider_top_shd, *slider_btm_shd, *rectbutton, *combo, *comboShadow, *buttonGlow, *roundFrame;
   TQPixmap *btnBlendPix, *menuPix, *groupShadow ;
   TQPixmap plainBrush, gradBrush;
   TQBrush pagerBrush, pagerHoverBrush;

   TQPixmap *pixmaps[ BITMAP_ITEMS ];
   TQPixmap sbBuffer;
   TQScrollBar *currentScrollBar;
   TQWMatrix lMatrix;
   TQWMatrix rMatrix;
   TQWMatrix iMatrix;
   TQWMatrix mMatrix;
   TQWMatrix m2Matrix;

   bool isKicker, isOOO, isHTMLButton, initialPaletteLoaded, inExitPolish;

   TQHeader *currentHeader;
   TQTabBar *currentTabBar;
   int headerHoverID;
   int headerSortID;
   TQPoint btnOffset;
   TQPoint cursorPos_;
   TQWidget *currentTaskContainer;
   KPixmap activeToolbarPix;
   bool isTaskContainer, taskContainerHover;

   TQPalette polishedPalette, tooltipPalette;
   unsigned int qtrcModificationTime;

   int progAnimShift;
   int prog2AnimShift;
   int sliderAnimShift;
   int hoveredTabIndex;
   bool mouseButtonPressed_;

   OptionHandler *optionHandler;

   TQIntDict<ButtonTile>btnDict;
   TQIntDict<ButtonFadeInfo>bfi;
   TQIntDict<TQRgb*>fadeColorMap;
   TQIntDict<ButtonTile>btnShadowedDict;
   TQIntDict<ButtonTile>buttonGlowDict;
   TQIntDict<ButtonTile>comboDict;
   TQIntDict<ButtonTile>comboShadowedDict;
   TQIntDict<ButtonTile>tabDict;
   TQIntDict<ButtonTile>inverseTabDict;
   TQIntDict<ButtonTile>rectBtnDict;
   TQIntDict<ButtonTile>progress2Dict;
   TQMap<TQWidget*, int> progAnimWidgets;

   TQPixmap *tmpBtnPix;
   ButtonTile *inactiveRoundFrame;
   ButtonTile *activeRoundFrame;

   TQWidget *highlightWidget;
   TQScrollBar *activeScroller;
   EventKiller *eventKiller;
   BMShower *bmShower;
   static TQPixmap popupBack;
   TQWidget *paintWidget;
};

#endif
