#include <tqbuffer.h>
#include "baghiralinkdrag.h"

static bool _accepted;

#define _TLO_ 0
#define _TO_ 4*sizeof(int)
#define _CLO_ 1*sizeof(int)
#define _CO_ 4*sizeof(int) + title.length()*sizeof(TQChar)
#define _CO2_ 4*sizeof(int) + title->length()*sizeof(TQChar)
#define _ILO_ 2*sizeof(int)
#define _IO_ 4*sizeof(int) + (title.length()+command.length())*sizeof(TQChar)
#define _IO2_ 4*sizeof(int) + (title->length()+command->length())*sizeof(TQChar)
#define _IxO_ 3*sizeof(int)

BaghiraLinkDrag::BaghiraLinkDrag(TQString title, TQString command, TQString icon, int index, TQWidget* dragSource) : TQDragObject(dragSource, 0)

{
   _accepted = false;
   a.resize((title.length()+command.length()+icon.length())*sizeof(TQChar)+4*sizeof(int));
   
   TQChar* tmpChar;
   int tmpLength;
   
   tmpChar = const_cast<TQChar*>(title.unicode());
   tmpLength = title.length();
   memcpy(a.data(), &tmpLength, sizeof(int));
   memcpy(a.data() + _TO_ , tmpChar, tmpLength*sizeof(TQChar));
   
   tmpChar = const_cast<TQChar*>(command.unicode());
   tmpLength = command.length();
   memcpy(a.data() + _CLO_ , &tmpLength, sizeof(int));
   memcpy(a.data() + _CO_, tmpChar, tmpLength*sizeof(TQChar));
   
   tmpChar = const_cast<TQChar*>(icon.unicode());
   tmpLength = icon.length();
   memcpy(a.data() + _ILO_, &tmpLength, sizeof(int));
   memcpy(a.data() + _IO_, tmpChar, tmpLength*sizeof(TQChar));
   
   memcpy(a.data() + _IxO_, &index, sizeof(int));
}

BaghiraLinkDrag::~BaghiraLinkDrag()
{
}

bool BaghiraLinkDrag::decode( const TQMimeSource * e, TQString * title,  TQString * command, TQString * icon, int * index)
{
   TQByteArray a = e->encodedData("application/baghiralink");
   
   if (a.size() < 4*sizeof(int)) // some empty stuff
   {
      return false;
   }
   
   TQChar* tmpChar;
   int tmpLength;
   
   memcpy(&tmpLength, a.data(), sizeof(int));
   tmpChar = new TQChar[tmpLength];
   memcpy(tmpChar, a.data() + _TO_, tmpLength*sizeof(TQChar));
   title->setUnicode(tmpChar, tmpLength);
   delete tmpChar;
   
   memcpy(&tmpLength, a.data() + _CLO_, sizeof(int));
   tmpChar = new TQChar[tmpLength];
   memcpy(tmpChar, a.data() + _CO2_, tmpLength*sizeof(TQChar));
   command->setUnicode(tmpChar, tmpLength);
   delete tmpChar;
   
   memcpy(&tmpLength, a.data() + _ILO_, sizeof(int));
   tmpChar = new TQChar[tmpLength];
   memcpy(tmpChar, a.data() + _IO2_, tmpLength*sizeof(TQChar));
   icon->setUnicode(tmpChar, tmpLength);
   delete tmpChar; tmpChar = 0L;
   
   memcpy(index, a.data() + _IxO_, sizeof(int));
  
   return true;
}

bool BaghiraLinkDrag::accepted()
{
   return _accepted;
}

bool BaghiraLinkDrag::canDecode( const TQMimeSource * e )
{
   return e->provides("application/baghiralink");
#if 0
   if (!e->provides("application/baghiralink"))
   {
      return false;
   }
   TQByteArray a = e->encodedData("application/baghiralink");
   if (a.size() != BAGHIRALINK_BUFSIZE)
   {
      return false;
   }
   return true;
#endif
}

void BaghiraLinkDrag::setAccepted()
{
   _accepted = true;
}

const char * BaghiraLinkDrag::format ( int i ) const
{
   if (i == 0)
   {
      return "application/baghiralink";
   }
   return 0;
}

TQByteArray BaghiraLinkDrag::encodedData ( const char * mimeType) const
{
   if (TQString("application/baghiralink") == mimeType)
   {
      return a;
   }
   return TQByteArray();
}
