/* IaOra KWin window decoration
  Based on plastik theme
  Copyright (C) 2003-2005 Sandro Giessl <sandro@giessl.com>

  based on the window decoration "Web":
  Copyright (C) 2001 Rik Hemsley (rikkus) <rik@kde.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
 */

#ifndef IAORA_H
#define IAORA_H

#include <tqfont.h>

#include <kdecoration.h>
#include <kdecorationfactory.h>

namespace KWinIaOra {

enum ColorType {
    TitleGradient1 = 0, // top
    TitleGradient2,
    TitleGradient3, // bottom
    TitleGradient4,
    ShadeTitleLight,
    ShadeTitleDark,
    Border1,
    Border2,
    Border3,
    TitleFont,
    TitleBorder
};

enum Pixmaps {
    TitleBarTileTop=0,
    TitleBarTile,
    TitleBarLeft,
    TitleBarRight,
    BorderLeftTile,
    BorderRightTile,
    BorderBottomTile,
    BorderBottomLeft,
    BorderBottomRight,
    NumPixmaps
};

enum ButtonIcon {
    CloseIcon = 0,
    MaxIcon,
    MaxRestoreIcon,
    MinIcon,
    HelpIcon,
    OnAllDesktopsIcon,
    NotOnAllDesktopsIcon,
    KeepAboveIcon,
    NoKeepAboveIcon,
    KeepBelowIcon,
    NoKeepBelowIcon,
    ShadeIcon,
    UnShadeIcon,
    NumButtonIcons
};

class IaOraHandler: public TQObject, public KDecorationFactory
{
    Q_OBJECT
public:
    IaOraHandler();
    ~IaOraHandler();
    virtual bool reset( unsigned long changed );

    virtual KDecoration* createDecoration( KDecorationBridge* );
    virtual bool supports( Ability ability );

    const TQPixmap &pixmap(Pixmaps type, bool active, bool toolWindow);
    const TQBitmap &buttonBitmap(ButtonIcon type, const TQSize &size, bool toolWindow);

    int  titleHeight()const { return m_titleHeight; }
    int  titleHeightTool()const { return m_titleHeightTool; }
    const TQFont &titleFont() { return m_titleFont; }
    const TQFont &titleFontTool() { return m_titleFontTool; }
    bool titleShadow()const { return m_titleShadow; }
    bool menuClose()const { return m_menuClose; }
    bool reverseLayout()const { return m_reverse; }
    TQColor getColor(KWinIaOra::ColorType type, const bool active = true);
    TQColor getGradientColor( KWinIaOra::ColorType type, const bool active);
    TQColor getBorderColor( KWinIaOra::ColorType type, const bool active);
    TQColor getShadowColor();

private:
    void readConfig();

    void pretile(TQPixmap *&pix, int size, TQt::Orientation dir) const;

    bool m_titleShadow;
    bool m_menuClose;
    bool m_reverse;
    int  m_titleHeight;
    int  m_titleHeightTool;
    TQFont m_titleFont;
    TQFont m_titleFontTool;

    // pixmap cache
    TQPixmap *m_pixmaps[2][2][NumPixmaps]; // button pixmaps have normal+pressed state...
    TQBitmap *m_bitmaps[2][NumButtonIcons];
};

IaOraHandler* Handler();

} // KWinPlastik

#endif // IAORA_H
