/* Plastik KWin window decoration
  Copyright (C) 2003-2005 Sandro Giessl <sandro@giessl.com>

  based on the window decoration "Web":
  Copyright (C) 2001 Rik Hemsley (rikkus) <rik@kde.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
 */

#ifndef IAORABUTTON_H
#define IAORABUTTON_H

#include <tqbutton.h>
#include <tqimage.h>
#include "iaora.h"

#include <kcommondecoration.h>

class TQTimer;

namespace KWinIaOra {

class IaOraClient;

class IaOraButton : public KCommonDecorationButton
{
    Q_OBJECT
public:
    IaOraButton(ButtonType type, IaOraClient *parent, const char *name);
    ~IaOraButton();

    void reset(unsigned long changed);
    IaOraClient * client() { return m_client; }


private:
    void enterEvent(TQEvent *e);
    void leaveEvent(TQEvent *e);
    void drawButton(TQPainter *painter);

private:
    IaOraClient *m_client;
    ButtonIcon m_iconType;
    bool hover;
};

/**
 * This class creates bitmaps which can be used as icons on buttons. The icons
 * are "hardcoded".
 * Over the previous "Gimp->xpm->TQImage->recolor->SmoothScale->TQPixmap" solution
 * it has the important advantage that icons are more scalable and at the same
 * time sharp and not blurred.
 */
class IconEngine
{
    public:
        static TQBitmap icon(ButtonIcon icon, int size);

    private:
        enum Object {
            HorizontalLine,
            VerticalLine,
            DiagonalLine,
            CrossDiagonalLine
        };

        static void drawObject(TQPainter &p, Object object, int x, int y, int length, int lineWidth);
};

} // namespace KWinIaOra

#endif // IAORABUTTON_H
