/*
 * Copyright (C) 2001 Rik Hemsley (rikkus) <rik@kde.org>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.	IN NO EVENT SHALL THE
 * AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef USERINTERFACE_H
#define USERINTERFACE_H

#include <noatun/plugin.h>

class TQToolButton;
class ScrollingLabel;
class Seeker;
class TQLabel;

/**
 * @short Main window class
 * @author Rik Hemsley <rik@kde.org>
 * @version 1.0
 */
class Charlatan : public TQWidget, public UserInterface
{
	Q_OBJECT
  

	public:

		Charlatan();
		virtual ~Charlatan();

		void load(const TQString & url);

	protected slots:

		virtual void slotConfigChanged();

		virtual void slotVolumeChanged(int);

		virtual void slotPlaying();
		virtual void slotStopped();
		virtual void slotPaused();

		virtual void slotPlayListShown();
		virtual void slotPlayListHidden();

		virtual void slotTimeout();

		virtual void slotRestart();

		virtual void slotStopShowingVolume();

	protected:

		virtual void mousePressEvent	(TQMouseEvent *);
		virtual void dragEnterEvent		(TQDragEnterEvent *);
		virtual void dropEvent				(TQDropEvent *);
		virtual void closeEvent				(TQCloseEvent *);
		virtual bool eventFilter			(TQObject *, TQEvent *);
		virtual void wheelEvent				(TQWheelEvent *);
		virtual void setTitleText			(const TQString & = TQString());

		void loadConfig();

	private:

		TQToolButton 		* previousButton_;
		TQToolButton 		* stopButton_;
		TQToolButton 		* playButton_;
		TQToolButton 		* nextButton_;
		TQToolButton 		* playListToggleButton_;
		TQToolButton 		* restartButton_;

		Seeker					* seekSlider_;
		ScrollingLabel	* titleLabel_;

		TQLabel					* positionLabel_;

		TQTimer					* showingVolumeTimer_;
		TQString						title_;
};

#endif
