// (c) 2000 Peter Putzer

#include <tqframe.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqvbox.h>
#include <tqhbox.h>
#include <tqgrid.h>
#include <tqdir.h>
#include <tqcheckbox.h>

#include <kdebug.h>
#include <tdelocale.h>
#include <klineedit.h>
#include <kiconloader.h>
#include <kcolorbutton.h>
#include <tdeapplication.h>
#include <tdemessagebox.h>

#include "ksv_conf.h"
// #include "ksvcolorconfig.h"
#include "ksvmiscconfig.h"
#include "ksvpathconfig.h"
#include "ksvlookandfeel.h"
// #include "ksvfontconfig.h"
#include "ksv_core.h"

#include "PreferencesDialog.h"

KSVPreferences::KSVPreferences (TQWidget* parent)
  :  KDialogBase (IconList, i18n("Configure"), Help|Ok|Apply|Cancel, Ok,
				  parent, "KSysV Preferences", true, true),
  mConfig (KSVConfig::self())
{
  setMinimumSize (sizeHint ());

  /**
   * Look & Feel Page
   */
  TQFrame* lafPage = addPage (i18n ("Look & Feel"), TQString(), DesktopIcon ("colorize", 32));
  mLookAndFeel = new KSVLookAndFeel (lafPage);
  connect( mLookAndFeel, TQT_SIGNAL( configChanged() ), this, TQT_SLOT( slotChanged() ) );

  TQVBoxLayout* lafLayout = new TQVBoxLayout (lafPage);
  lafLayout->addWidget (mLookAndFeel);

//   /**
//    * Colors Page
//    */
//   TQFrame* colorPage = addPage (i18n("Colors"), TQString(), DesktopIcon ("colorize", 32));
//   mColorConfig = new KSVColorConfig(colorPage);

//   TQVBoxLayout* colorLayout = new TQVBoxLayout(colorPage);
//   colorLayout->addWidget(mColorConfig);

//   /**
//    * Fonts Page
//    */
//   TQFrame* fontPage = addPage (i18n("Fonts"), TQString(), DesktopIcon ("fonts", 32));
//   mFontConfig = new KSVFontConfig(fontPage);

//   TQVBoxLayout* fontLayout = new TQVBoxLayout (fontPage);
//   fontLayout->addWidget(mFontConfig);

  /**
   * Paths Page
   */
  TQFrame* pathPage = addPage (i18n ("Paths"), TQString(), DesktopIcon ("kfm", 32));
  mPathConfig = new KSVPathConfig(pathPage);
  connect( mPathConfig, TQT_SIGNAL( configChanged() ), this, TQT_SLOT( slotChanged() ) );

  TQVBoxLayout *pathLayout = new TQVBoxLayout (pathPage);
  pathLayout->addWidget (mPathConfig);

  /**
   * Miscellaneous Page
   */
  TQFrame* miscPage = addPage (i18n ("Miscellaneous"), i18n("Settings Not Fitting Anywhere Else"),
                              DesktopIcon ("misc", 32));
  mMiscConfig = new KSVMiscConfig(miscPage);
  connect( mMiscConfig, TQT_SIGNAL( configChanged() ), this, TQT_SLOT( slotChanged() ) );

  TQVBoxLayout *miscLayout = new TQVBoxLayout (miscPage);
  miscLayout->addWidget (mMiscConfig);

  connect (mMiscConfig->mShowAll, TQT_SIGNAL (clicked()), this, TQT_SLOT (showAllMessages()));

  reReadConfig();
  enableButton( Apply, false );
  configChanged = false;
}

KSVPreferences::~KSVPreferences ()
{
}

void KSVPreferences::slotChanged()
{
  enableButton( Apply, true );
  configChanged = true;
}

void KSVPreferences::reReadConfig()
{
  mPathConfig->mRunlevelPath->setText(mConfig->runlevelPath());
  mPathConfig->mServicesPath->setText(mConfig->scriptPath());

  mLookAndFeel->mNewNormal->setColor (mConfig->newNormalColor());
  mLookAndFeel->mNewSelected->setColor (mConfig->newSelectedColor());

  mLookAndFeel->mChangedNormal->setColor (mConfig->changedNormalColor ());
  mLookAndFeel->mChangedSelected->setColor (mConfig->changedSelectedColor ());

  mLookAndFeel->setServiceFont (mConfig->serviceFont());
  mLookAndFeel->setNumberFont (mConfig->numberFont());

  reReadMessages();
}

void KSVPreferences::slotCancel ()
{
  reject();
  reReadConfig();
}

void KSVPreferences::slotApply ()
{
  if (checkPaths())
  {
    setConfig();
    enableButton( Apply, false );
    configChanged = false;
  }
}

bool KSVPreferences::checkPaths ()
{
  bool result = true;

  if (!TQDir(mPathConfig->mServicesPath->text()).exists())
    result = (KMessageBox::warningContinueCancel(this,
                                                 i18n ("The service folder you specified does "
                                                       "not exist.\n"
                                                       "You can continue if you want to, "
                                                       "or you can click Cancel "
                                                       "to select a new folder."),
                                                 i18n ("Warning"))
              != KMessageBox::Cancel);

  if (!TQDir(mPathConfig->mRunlevelPath->text()).exists())
    result = result
      && (KMessageBox::warningContinueCancel(this,
                                             i18n ("The runlevel folder you specified does "
                                                   "not exist.\n"
                                                   "You can continue if you want to, "
                                                   "or you can click Cancel "
                                                   "to select a new folder."),
                                             i18n ("Warning"))
          != KMessageBox::Cancel);

  return result;
}

void KSVPreferences::slotOk ()
{
  if (checkPaths())
    {
      accept();
      setConfig ();
    }
}

TQColor KSVPreferences::newNormal() const
{
  return mLookAndFeel->mNewNormal->color();
}

TQColor KSVPreferences::newSelected() const
{
  return mLookAndFeel->mNewSelected->color();
}

TQColor KSVPreferences::changedNormal() const
{
  return mLookAndFeel->mChangedNormal->color();
}

TQColor KSVPreferences::changedSelected() const
{
  return mLookAndFeel->mChangedSelected->color();
}


KSVPreferences* KSVPreferences::self ()
{
  static KSVPreferences* prefs = new KSVPreferences (kapp->mainWidget());

  return prefs;
}

void KSVPreferences::setConfig ()
{
  // if necessary, update service path
  {
    TQString sp = mPathConfig->mServicesPath->text();
    if (sp != mConfig->scriptPath())
      {
        mConfig->setScriptPath (sp);

        emit updateServicesPath ();
      }
  }

  // if necesssary, update root path for runlevels
  {
    TQString rp = mPathConfig->mRunlevelPath->text();
    if (rp != mConfig->runlevelPath ())
      {
        mConfig->setRunlevelPath (rp);
        
        emit updateRunlevelsPath ();
      }
  }
  
  // if necessary, update miscellaneous settings
  {
    mConfig->setShowMessage (ksv::RunlevelsReadOnly,
                             mMiscConfig->mWarnReadOnly->isChecked());
    mConfig->setShowMessage (ksv::CouldNotGenerateSortingNumber,
                             mMiscConfig->mWarnSortingNumber->isChecked());
  }

  // if necessary, update colors
  {
    TQColor nn = newNormal();
    TQColor ns = newSelected();
    TQColor cn = changedNormal();
    TQColor cs = changedSelected();
    
    if (nn != mConfig->newNormalColor() ||
        ns != mConfig->newSelectedColor() ||
        cn != mConfig->changedNormalColor() ||
        cs != mConfig->changedSelectedColor())
      {
        mConfig->setNewNormalColor (nn);
        mConfig->setNewSelectedColor (ns);
        mConfig->setChangedNormalColor (cn);
        mConfig->setChangedSelectedColor (cs);
        
        emit updateColors ();
      }
  }
  
  // if necessary, update fonts
  {
    const TQFont& sf = mLookAndFeel->serviceFont();
    const TQFont& ns = mLookAndFeel->numberFont();
    
    if (sf != mConfig->serviceFont() || ns != mConfig->numberFont())
      {
        mConfig->setServiceFont (sf);
        mConfig->setNumberFont (ns);

        emit updateFonts();
      }
  }
}

void KSVPreferences::showAllMessages ()
{
  KMessageBox::enableAllMessages ();
  
  // update checkboxes
  reReadMessages();
}

void KSVPreferences::reReadMessages()
{
  mMiscConfig->mWarnReadOnly->setChecked (mConfig->showMessage (ksv::RunlevelsReadOnly));
  mMiscConfig->mWarnSortingNumber->setChecked (mConfig->showMessage (ksv::CouldNotGenerateSortingNumber));
}

void KSVPreferences::showEvent (TQShowEvent* e)
{
  reReadMessages();

  KDialogBase::showEvent (e);
}

#include "PreferencesDialog.moc"
