/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/

#include <tdeapplication.h>
#include <kdebug.h>
#include "tdeio.h"

Kio::Kio()
{
}

bool Kio::download(const KURL & from, const TQString & to)
{
    TDEIO::Job *iojob = TDEIO::file_copy(from, to);
    connect( iojob, TQ_SIGNAL( result(TDEIO::Job*) ),
	     TQ_SLOT( slotIOJobFinished( TDEIO::Job* )));
    // missing modal widget hack here.
    // I'd recommend using TDEIO::NetAccess instead (David).
    kapp->enter_loop();
    return worked;
}

void Kio::slotIOJobFinished( TDEIO::Job * job)
{
    worked = (job->error() == 0);
    kapp->exit_loop();
}

Kiod::Kiod()
{
    file=0L;
    fileT = 0L;
}

Kiod::~Kiod()
{
    delete file;
    delete fileT;
}

bool Kiod::listDir(const TQString &url, const TQString &fname, bool subdirs)
{
    delete file;
  file = new TQFile(fname);
  if (file->open(IO_WriteOnly)) {
      delete fileT;
    fileT = new TQTextStream(file);
    TDEIO::ListJob *job;
    if (!subdirs)
        job = TDEIO::listDir( url );
    else
        job = TDEIO::listRecursive( url, false);

    kdDebug() << "started " << job <<  " " << subdirs << endl;

    TQObject::connect( job, TQ_SIGNAL( entries( TDEIO::Job*, const TDEIO::UDSEntryList& ) ),
		      TQ_SLOT( slotListEntries( TDEIO::Job*, const TDEIO::UDSEntryList& ) ) );
    TQObject::connect( job, TQ_SIGNAL( result( TDEIO::Job * ) ),
		      TQ_SLOT( slotFinished( TDEIO::Job* ) ) );

    kapp->enter_loop();

    file->close();
    if (worked)
      return TRUE;
    else
      return FALSE;
  } else
    return FALSE;
}

void Kiod::slotListEntries( TDEIO::Job *, const TDEIO::UDSEntryList& entries )
{
  long size = 0;
  TQString text;

  TDEIO::UDSEntryList::ConstIterator entryIt = entries.begin();

  for (; entryIt != entries.end(); ++entryIt) {
      //kdDebug() << "listDir " << dynamic_cast<TDEIO::ListJob*>(job)->url() << endl;
      for (TDEIO::UDSEntry::ConstIterator it = (*entryIt).begin();
	   it != (*entryIt).end(); it++ )
      {
	  if ( (*it).m_uds == TDEIO::UDS_SIZE )
	      size = (*it).m_long;
	  else if ( (*it).m_uds == TDEIO::UDS_NAME )
	      text = (*it).m_str;
      }
      *fileT << text << "\n" << size << "\n";
      kdDebug() << text << " " << size << "\n";
  }
}

void Kiod::slotFinished( TDEIO::Job *job )
{
    //kdDebug() << "finished" << " " << job << " " << dynamic_cast<TDEIO::ListJob*>(job)->url() << endl;
    worked = (job->error() == 0);
    kapp->exit_loop();
}

#include "tdeio.moc"
