require 'Qt'

class LCDRange < TQt::Widget
    signals 'valueChanged(int)'
    slots 'setValue(int)', 'setRange(int, int)', 'setText(const char*)'
    
    def initialize(s, parent, name)
        super(parent, name)
        init()
        setText(s)
    end
    
    def init()
        @lcd = TQt::LCDNumber.new(2, self, 'lcd')
        @slider = TQt::Slider.new(TQt::VBox::Horizontal, self, 'slider')
        @slider.setRange(0, 99)
        @slider.setValue(0)
        
        @label = TQt::Label.new( ' ', self, 'label'  )
        @label.setAlignment( TQt::AlignCenter )
            
        connect(@slider, SIGNAL('valueChanged(int)'), @lcd, SLOT('display(int)'))
        connect(@slider, SIGNAL('valueChanged(int)'), SIGNAL('valueChanged(int)'))
        
        setFocusProxy(@slider)
        
        @l = TQt::VBoxLayout.new( self )
        @l.addWidget( @lcd, 1 )
        @l.addWidget( @slider )
        @l.addWidget( @label )
    end
    
    def value()
        @slider.value()
    end

    def setValue( value )
        @slider.setValue( value )
    end
    
    def setRange( minVal, maxVal )
		if minVal < 0 || maxVal > 99 || minVal > maxVal
      		tqWarning( "LCDRange::setRange(#{minVal},#{maxVal})\n" +
               		"\tRange must be 0..99\n" +
               		"\tand minVal must not be greater than maxVal" )
			return
		end
        @slider.setRange( minVal, maxVal )
    end
    
    def setText( s )
        @label.setText( s )
    end

end
