#include "qtsharp.h"
#include <cstdio>

static qtsharp_EventDelegate QtSharp_EventDelegate = 0;

static int qtsharp_delegateBridge (void *arg1, char *arg2, void *arg3, char *arg4)
{
	if (QtSharp_EventDelegate)
		(*QtSharp_EventDelegate)(arg1, arg2, arg3, arg4);

	return 0;
}

extern "C"
void qtsharp_QObject_registerEventDelegate (qtsharp_EventDelegate delegate)
{
	QtSharp_EventDelegate = delegate;
	qt_QObject_registerEventDelegate (qtsharp_delegateBridge);
	return;
}

TQObject *csharp_connect_void (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(void))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (void)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_item_void (TQMenuData *instance, int id, TQObject *receiver, void (*ptr)(void))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! instance->connectItem (id, cs, TQ_SLOT (callback (void)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_bool (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(bool))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (bool)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_short (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(short))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (short)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_int (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(int))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (int)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_item_int (TQMenuData *instance, int id, TQObject *receiver, void (*ptr)(int))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! instance->connectItem (id, cs, TQ_SLOT (callback (int)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_long (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(long))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (long)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_float (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(float))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (float)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_double (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(double))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (double)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_QString (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(const TQString&))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (const TQString&)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_QDockWindow (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(TQDockWindow*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (TQDockWindow*)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_QDropEvent (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(TQDropEvent*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (TQDropEvent*)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_QDropEventTQListViewItem (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(TQDropEvent*,TQListViewItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (TQDropEvent*,TQListViewItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_QIconViewItem (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(TQIconViewItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (TQIconViewItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_QListBoxItem (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(TQListBoxItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (TQListBoxItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_QListViewItem (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(TQListViewItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (TQListViewItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_QListViewItemTQListViewItem (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(TQListViewItem*,TQListViewItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (TQListViewItem*,TQListViewItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_QListViewItemTQListViewItemTQListViewItem (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(TQListViewItem*,TQListViewItem*,TQListViewItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (TQListViewItem*,TQListViewItem*,TQListViewItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_QNetworkOperation (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(TQNetworkOperation*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (TQNetworkOperation*)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_QObject (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(TQObject*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (TQObject*)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_QToolBar (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(TQToolBar*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (TQToolBar*)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_QWidget (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(TQWidget*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (TQWidget*)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_intTQIconViewItem (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(int,TQIconViewItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (int,TQIconViewItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_intTQListBoxItem (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(int,TQListBoxItem*))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (int,TQListBoxItem*)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_intbool (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(int,bool))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (int,bool)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_intint (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(int,int))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (int,int)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

TQObject *csharp_connect_intintint (TQObject *sender, const char *signal, TQObject *receiver, void (*ptr)(int,int,int))
{
	CustomSlot *cs = new CustomSlot (ptr, receiver);
	if (! TQObject::connect (sender, signal, cs, TQ_SLOT (callback (int,int,int)))) {
		delete cs;
		cs = 0L;
	}
	return (TQObject *)cs;
}

