/*
 *
 *  Device Manager Gui for tdebluez
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of tdebluez.
 *
 *  tdebluez is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  tdebluez is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#ifndef DEVICEWIZARD_H
#define DEVICEWIZARD_H

#include <tqheader.h>
#include <tqtoolbutton.h>
#include <tqlabel.h>
//
#include <tqlistview.h>
#include <kpixmap.h>
#include <kiconloader.h>
#include <kpixmapeffect.h>

#include <objectmanagerImpl.h>
#include <adapterImpl.h>
#include <deviceImpl.h>

#include "devicedialog.h"
#include "devicedialog_ext.h"
#include "devicesetupwizard.h"
//#include "mediacontrol.h"

using namespace TDEBluetooth;

class DeviceWizard: public DeviceDialog
{
    Q_OBJECT

public:
    DeviceWizard(TDEBluetoothApp* app);
    ~DeviceWizard();

private:
    void setStateDeviceButtons(bool state);

private slots:
    // device wizard ui
    void slotDeviceBoxClicked(TQListViewItem*);
    void slotChangeSetupButton(TQListViewItem*);
    void slotConnectButton();
    void slotCloseDialog();
    void slotSearch(bool state);
    void slotUpdateLogo();
    void slotInsertDevice(const TQString& path);
    void slotSetupNewDevice();
    void slotDeleteDevice();
    void slotConfigDevice();

    // supportive
    void slotConnectNextProfile();
    void slotSetAdapter(const TQString& path, const TQString& name);

    // MANAGER -> device wizard
    // adapter related
    void slotAdapterDiscoveringChanged(const TQString&, bool);
    //	void slotMediaControlConnectedChanged(const TQString&, bool);
    // device related
//    void slotSetConnectedIcon(const TQString&);
//    void slotSetDisconnectedIcon(const TQString&);
    void slotDeviceConnectedChanged(const TQString&, bool);
    void slotDeviceRemoved(const TQString& path);
    void slotDevicePairedChanged(const TQString&, bool);
    void slotDeviceNameChanged(const TQString&, const TQString&);

    void slotAsyncErrorResponseDetected(int asyncCallId, const TQT_DBusError dbuserr);
//    void slotConnectAsyncReply(int asyncCallId);
//    void slotConnectProfileAsyncReply(int asyncCallId);



private:
    TDEBluetoothApp *app;
    AdapterImpl *adapter;

    DeviceDialog_Ext *devicedlg_ext;
    DeviceSetupWizard *devicesetupwizard;
    //  MediaControl *mediaCtlDialog;

    enum ConState
    {
        IDLE = 0, CONNECTING, DISCONNECTING
    };

    struct ConnectDevice {
        ConState state;
        TQString address;
        TQStringList profiles; // when multiple profiles are to be connected
    };

    KPixmap logoBlend;
    KPixmap pix;
    KPixmap mainlogo;

    TQTimer* chgLogoTimer;
    bool timer;

    ConnectDevice connectingDevice;
};

#endif
