/*
 *
 *  MediaControl for tdebluez
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of tdebluez.
 *
 *  tdebluez is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  tdebluez is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef MEDIACONTROL_H_INCLUDED
#define MEDIACONTROL_H_INCLUDED

#include <kdialogbase.h>
#include <tqobject.h>

#include <interfaces/mediacontrol1Proxy.h>
#include "mediactl.h"

class MediaControl: public MediaCtlDlg
{
    Q_OBJECT

public:
    MediaControl(TQString path, TQT_DBusConnection* conn);
    ~MediaControl();
//		void closeMediaControl();

public slots:
    void slotPlay();
    void slotPlayToggled(bool);
    void slotStop();
    void slotPause();
    void slotNext();
    void slotPrevious();
    void slotFastForward();
    void slotRewind();
    void slotVolumeValueChanged(int);

private:
    TQString mPath;
    int volume;
    org::bluez::MediaControl1Proxy *mediaCtlProxy;
    TQPixmap pixStart;
    TQPixmap pixPause;

};

#endif //MEDIACONTROL_H_INCLUDED

// End of File
