//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kdebluetooth@schaettgen.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _TDEIOBT_H_
#define _TDEIOBT_H_

#include <tdeio/forwardingslavebase.h>
#include <vector>

#include <adapterImpl.h>
#include <objectmanagerImpl.h>

class TDEioBluetooth : public TDEIO::ForwardingSlaveBase
{
    Q_OBJECT

public:
    TDEioBluetooth(const TQCString &protocol, const TQCString &pool_socket, const TQCString &app_socket);
    virtual ~TDEioBluetooth();
    virtual void closeConnection();
    virtual void stat(const KURL &url);
    virtual void listDir(const KURL &url);

protected:
    virtual bool rewriteURL(const KURL &url, KURL &newUrl);

private:
    void createTopLevelEntry(TDEIO::UDSEntry& entry);
    bool listDevice(TDEIO::UDSEntry &entry, const TQString &path, const KURL &url);
    bool listDevices(TQValueList<TDEIO::UDSEntry> &list, const KURL &url);
    bool listServices(TQValueList<TDEIO::UDSEntry> &list, const KURL &url);
    bool createDirEntry(TDEIO::UDSEntry &entry, const TQString &title,
    		const TQString &dir = TQString::null, const TQString &mimeType = "inode/directory");
    void addAtom(TDEIO::UDSEntry &entry, TDEIO::UDSAtomTypes type, TQString s);
    void addAtom(TDEIO::UDSEntry &entry, TDEIO::UDSAtomTypes type, long l);

    TDEBluetooth::AdapterImpl *adapter;
    TDEBluetooth::ObjectManagerImpl *manager;

private slots:    
    void slotAddDevice(const TQString &address);
    void slotAddService(const KURL &url, const TQString uuid);
    void slotRemoveDevice(const TQString &address);
    void slotAdapterPowerOnChanged(const TQString & path, bool state) ;

};

#endif //TDEIOBT
