/*
 *
 *  Device Mime Converter for libtdebluez
 *
 *  Copyright (C) 2003 by Fred Schaettgen
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of libtdebluez.
 *
 *  libtdebluez is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  libtdebluez is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef DEVICEMIMECONVERTER_H
#define DEVICEMIMECONVERTER_H

#include <map>

namespace TDEBluetooth
{
/**
 @author Fred Schaettgen
 */
class KDE_EXPORT DeviceMimeConverter
{
public:
    static TQString classToMimeType(int deviceClass);
    static TQString mimeTypeToIcon(TQString mimeType);
    static TQString classToIconName(int deviceClass);
protected:
    DeviceMimeConverter();
    static DeviceMimeConverter *getInstance();
private:
    std::map<TQString, TQString> mimeTypeToIconMap;
    void getIconName(TQString mimetype);
};

} // TDEBluetooth

#endif
