/*
 *
 *  Device Implementation of bluez5 for libtdebluez
 *
 *  Copyright (C) 2018  Emanoil Kotsev <deloptes@gmail.com>
 *
 *
 *  This file is part of libtdebluez.
 *
 *  libtdebluez is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  libtdebluez is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kbluetooth; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#if !defined(DEVICEIMPL_H_INCLUDED)
#define DEVICEIMPL_H_INCLUDED

// TQt - Header
#include <tqtimer.h>

// debug
#include <kdebug.h>

#include "interfaces/device1Proxy.h"
#include "interfaces/propertiesProxy.h"

namespace TDEBluetooth
{

class KDE_EXPORT DeviceImpl: public org::bluez::Device1Proxy
{
    TQ_OBJECT

public:
    DeviceImpl(const TQString& service, const TQString& path, TQObject* parent = 0, const char* name = 0);

    virtual ~DeviceImpl();
    const TQString getPath();

private:
    TQString m_path;

};
// class DeviceImpl

};
// namespace TDEBluetooth

#endif //DEVICEIMPL_H_INCLUDED

// End of File
