TEMPLATE = app
DEPENDPATH += i18n src
INCLUDEPATH += . src  /usr/include/X11 /usr/include/X11R6
LIBPATH += /usr/X11/lib /usr/X11R6/lib
LIBS = -lX11 -lXpm -lXmu
TARGET = tdedocker
INSTALL_PATH = /usr/local/share/tdedocker
DOCS_PATH = $$INSTALL_PATH/docs

# Defines
TRANSLATIONS_PATH = $$INSTALL_PATH/i18n
DEFINES += TRANSLATIONS_PATH='"$$TRANSLATIONS_PATH"'

ICONS_PATH = $$INSTALL_PATH/icons
DEFINES += ICONS_PATH='"$$ICONS_PATH"'

# Installation
icons.path = $$ICONS_PATH
icons.files = icons/tdedocker.png icons/question.png

translations.path = $$TRANSLATIONS_PATH
translations.files = i18n/*.qm

docs.path = $$DOCS_PATH
docs.files = README

desktop.path = /usr/share/applications
desktop.files = tdedocker.desktop

target.path = /usr/local/bin

INSTALLS += target icons docs translations desktop

# Input
HEADERS += src/customtraylabel.h \
           src/tdedocker.h \
           src/qtraylabel.h \
           src/trace.h \
           src/traylabelmgr.h \
           src/util.h
SOURCES += src/customtraylabel.cpp \
           src/tdedocker.cpp \
           src/main.cpp \
           src/qtraylabel.cpp \
           src/trace.cpp \
           src/traylabelmgr.cpp \
           src/util.cpp
           
TRANSLATIONS += i18n/tdedocker_en.ts i18n/tdedocker_es.ts i18n/tdedocker_fr.ts \
                i18n/tdedocker_cs.ts i18n/tdedocker_ru.ts i18n/tdedocker_pt_BR.ts \
                i18n/tdedocker_de.ts i18n/tdedocker_pl.ts i18n/tdedocker_id.ts \
                i18n/tdedocker_it.ts i18n/tdedocker_bg.ts i18n/tdedocker_ja.ts \
                i18n/tdedocker_nl.ts i18n/tdedocker_hu.ts i18n/tdedocker_sv.ts

# Debugging (Uncomment line below and make clean; make")
# DEFINES += ENABLE_TRACING

# Output
MOC_DIR = tmp
OBJECTS_DIR = tmp
DESTDIR = .

