/*
 Kopete Alias Plugin

 Copyright (c) 2005 by Matt Rogers <mattr@kde.org>
 Kopete Copyright (c) 2002-2005 by the Kopete Developers <kopete-devel@kde.org>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************

*/

#include "editaliasdialog.h"
#include <tqobject.h>
#include <kpushbutton.h>
#include <tqwidget.h>
#include <tqstring.h>
#include <klineedit.h>
#include <tdelistview.h>


EditAliasDialog::EditAliasDialog( TQWidget* parent, const char* name )
: AliasDialog( parent, name )
{
	TQObject::connect( alias, TQ_SIGNAL( textChanged( const TQString& ) ), this, TQ_SLOT( checkButtonsEnabled() ) );
	TQObject::connect( command, TQ_SIGNAL( textChanged( const TQString& ) ), this, TQ_SLOT( checkButtonsEnabled() ) );
	TQObject::connect( protocolList, TQ_SIGNAL( selectionChanged() ), this, TQ_SLOT( checkButtonsEnabled() ) );

	checkButtonsEnabled();
}

EditAliasDialog::~EditAliasDialog()
{
}

void EditAliasDialog::checkButtonsEnabled()
{
	if ( !alias->text().isEmpty() && !command->text().isEmpty() && !protocolList->selectedItems().isEmpty() )
		addButton->setEnabled( true );
	else
		addButton->setEnabled( false ) ;
}

#include "editaliasdialog.moc"
