/*
    outgoingtransfer.h - msn p2p protocol

    Copyright (c) 2003-2005 by Olivier Goffart        <ogoffart@ kde.org>
    Copyright (c) 2005      by Gregg Edghill          <gregg.edghill@gmail.com>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef OUTGOINGTRANSFER_H
#define OUTGOINGTRANSFER_H

#include "p2p.h"
#include "dispatcher.h"
#include <tqstringlist.h>

/**
@author Kopete Developers
*/
namespace P2P{
	class OutgoingTransfer : public TransferContext
	{	TQ_OBJECT
  
		public:
			OutgoingTransfer(const TQString& to, P2P::Dispatcher *dispatcher, TQ_UINT32 sessionId);
			virtual ~OutgoingTransfer();

			void sendImage(const TQByteArray& image);

		private slots:
			void slotConnected();
			void slotRead();
			void slotSendData();
			void slotSocketError(int);
			void slotSocketClosed();
			
		private:
			virtual void acknowledged();
			void connectToEndpoint(const TQString& hostName);
			virtual void processMessage(const Message& message);

			TQStringList m_peerEndpoints;
			TQStringList::Iterator m_endpointIterator;
			TQString m_remotePort;
			TQString m_nonce;
			char m_handshake;

		protected:
			virtual void readyToSend();
	};
}

#endif
