/*
    This file is part of KAddressBook.
    Copyright (c) 2002 Mike Pilone <mpilone@slac.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef ADDRESSEEEDITORWIDGET_H
#define ADDRESSEEEDITORWIDGET_H

#include <tqdatetime.h>

#include <tdeabc/addressee.h>
#include <kdialogbase.h>
#include <kjanuswidget.h>

#include "addresseeeditorbase.h"
#include "contacteditorwidgetmanager.h"
#include "extensionwidget.h"

class TQCheckBox;
class TQSpinBox;
class TQTabWidget;
class TQTextEdit;

class KComboBox;
class KDateEdit;
class KLineEdit;
class KSqueezedTextLabel;

class AddressEditWidget;
class EmailEditWidget;
class IMEditWidget;
class KeyWidget;
class PhoneEditWidget;
class SecrecyWidget;

namespace KAB {
class Core;
}

namespace KPIM {
class AddresseeLineEdit;
class CategorySelectDialog;
class CategoryEditDialog;
}

namespace TDEABC { class AddressBook; }

class AddresseeEditorWidget : public AddresseeEditorBase
{
  Q_OBJECT
  

  public:
    AddresseeEditorWidget( TQWidget *parent, const char *name = 0 );
    ~AddresseeEditorWidget();

    void setAddressee( const TDEABC::Addressee& );
    const TDEABC::Addressee &addressee();

    void load();
    void save();

    bool dirty();

    void setInitialFocus();

    bool readyToClose();

  protected slots:
    void textChanged( const TQString& );
    void pageChanged( TQWidget *wdg );

    /**
      Emits the modified signal and sets the dirty flag. Any slot
      that modifies data should use this method instead of calling emit
      modified() directly.
     */
    void emitModified();

    void dateChanged( const TQDate& );
    void invalidDate();
    void nameTextChanged( const TQString& );
    void organizationTextChanged( const TQString& );
    void nameBoxChanged();
    void nameButtonClicked();
    void selectCategories();

    /**
      Called whenever the categories change in the categories dialog.
     */
    void categoriesSelected( const TQStringList& );

    /**
      Edits which categories are available in the CategorySelectDialog.
     */
    void editCategories();

  private:
    void initGUI();
    void setupTab1();
    void setupTab2();
    void setupAdditionalTabs();
    void setupCustomFieldsTabs();

    void setReadOnly( bool );

    TDEABC::Addressee mAddressee;
    int mFormattedNameType;
    bool mDirty;
    bool mBlockSignals;
    bool mReadOnly;

    // GUI
    KPIM::CategorySelectDialog *mCategorySelectDialog;
    KPIM::CategoryEditDialog *mCategoryEditDialog;
    TQTabWidget *mTabWidget;

    // Tab1
    KLineEdit *mNameEdit;
    KLineEdit *mRoleEdit;
    KLineEdit *mOrgEdit;
    KSqueezedTextLabel *mFormattedNameLabel;
    AddressEditWidget *mAddressEditWidget;
    EmailEditWidget *mEmailWidget;
    IMEditWidget *mIMWidget;
    PhoneEditWidget *mPhoneEditWidget;
    KLineEdit *mURLEdit;
    KLineEdit *mBlogEdit;
    TQPushButton *mCategoryButton;
    KLineEdit *mCategoryEdit;
    SecrecyWidget *mSecrecyWidget;
    KSqueezedTextLabel *mNameLabel;

    // Tab2
    KLineEdit *mDepartmentEdit;
    KLineEdit *mOfficeEdit;
    KLineEdit *mProfessionEdit;
    KLineEdit *mTitleEdit;
    KPIM::AddresseeLineEdit *mManagerEdit;
    KPIM::AddresseeLineEdit *mAssistantEdit;
    KLineEdit *mNicknameEdit;
    KPIM::AddresseeLineEdit *mSpouseEdit;
    KDateEdit *mBirthdayPicker;
    KDateEdit *mAnniversaryPicker;
    TQTextEdit *mNoteEdit;

    TQDict<ContactEditorTabPage> mTabPages;
};

#endif
