/*
    KNode, the KDE newsreader
    Copyright (c) 2003 Zack Rusin <zack@kde.org>
    Copyright (c) 2004-2005 Volker Krause <volker.krause@rwth-aachen.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, US
*/
#ifndef KNMAINWIDGET_H
#define KNMAINWIDGET_H

#include "knodeiface.h"

#include <kdockwidget.h>
#include <kdialogbase.h>
#include "resource.h"

#include <tqglobal.h>
#include <kdemacros.h>

class TQListViewItem;

class KURL;
class TDEAccel;
class TDEAction;
class TDEToggleAction;
class TDESelectAction;
class KRSqueezedTextLabel;
class KLineEdit;
class KXMLGUIClient;

class KNHeaderView;
class KNCollectionView;
class KNCollectionViewItem;
class KNProgress;
class KNConfigManager;
class KNAccountManager;
class KNGroupManager;
class KNFolderManager;
class KNArticleManager;
class KNArticleFactory;
class KNFilterManager;
class KNScoringManager;
class KNMemoryManager;
class KNFilterSelectAction;
class KNNetAccess;
namespace Kpgp {
    class Module;
}
namespace KNode {
  class ArticleWidget;
}
class KNArticle;
class KNLocalArticle;
class KNRemoteArticle;
class TDEActionCollection;

class KDE_EXPORT KNMainWidget : public KDockArea, virtual public KNodeIface
{
  Q_OBJECT
  
public:
  KNMainWidget( KXMLGUIClient *client, bool detachable, TQWidget* parent, const char* name );
  ~KNMainWidget();

  /** exit */
  bool queryClose();
  void prepareShutdown();

  //GUI
  void setStatusMsg(const TQString& = TQString(), int id=SB_MAIN);
  void setStatusHelpMsg(const TQString& text);
  void updateCaption();
  void setCursorBusy(bool b=true);
  void blockUI(bool b=true);
  void disableAccels(bool b=true);
  /** processEvents with some blocking */
  void secureProcessEvents();

  /** useful default value */
  virtual TQSize sizeHint() const;

  /** handle URL given as command-line argument */
  void openURL(const KURL &url);

  /** update fonts and colors */
  void configChanged();

  /** access to GUI-elements */
  KNCollectionView* collectionView()const  { return c_olView; }
  KNHeaderView*       headerView()const      { return h_drView; }
  KNode::ArticleWidget* articleViewer() const     { return mArticleViewer; }
  KRSqueezedTextLabel*  statusBarLabelGroup() const { return s_tatusGroup; }
  KRSqueezedTextLabel*  statusBarLabelFilter() const { return s_tatusFilter; }
  public: //The dcop interface
  // Implementation of KNodeIface
  /* Navigation */
  // Move to the next article
  virtual void nextArticle();
  // Move to the previous article
  virtual void previousArticle();
  // Move to the next unread article
  virtual void nextUnreadArticle();
  // Move to the next unread thread
  virtual void nextUnreadThread();
  // Move to the next group
  virtual void nextGroup();
  // Move to the previous group
  virtual void previousGroup();

  /* Group options */
  // Open the editor to post a new article in the selected group
  virtual void postArticle();
  // Fetch the new headers in the selected groups
  virtual void fetchHeadersInCurrentGroup();
  // Expire the articles in the current group
  virtual void expireArticlesInCurrentGroup();
  // Mark all the articles in the current group as read
  virtual void markAllAsRead();
  // Mark all the articles in the current group as unread
  virtual void markAllAsUnread();

  /* Header view */
  // Mark the current article as read
  virtual void markAsRead();
  // Mark the current article as unread
  virtual void markAsUnread();
  // Mark the current thread as read
  virtual void markThreadAsRead();
  // Mark the current thread as unread
  virtual void markThreadAsUnread();

  /* Articles */

  // Send the pending articles
  virtual void sendPendingMessages();
  // Delete the current article
  virtual void deleteArticle();
  // Send the current article
  virtual void sendNow();
  // Edit the current article
  virtual void editArticle();
  /// Fetch all the new article headers
  virtual void fetchHeaders();
  /// Expire articles in all groups
  virtual void expireArticles();

  /* Kontact integration */
  /// Process command-line options
  virtual bool handleCommandLine();

  //end dcop interface
signals:
  void signalCaptionChangeRequest( const TQString& );

protected:

  TDEActionCollection* actionCollection() const;
  KXMLGUIFactory *factory() const;

  void initActions();
  void iniStatusBar();

  /** checks if run for the first time, sets some global defaults (email configuration) */
  bool firstStart();

  void readOptions();
  void saveOptions();

  bool requestShutdown();

  virtual void showEvent(TQShowEvent *);

  /** update appearance */
  virtual void fontChange( const TQFont & );
  virtual void paletteChange ( const TQPalette & );

  bool eventFilter(TQObject *, TQEvent *);

  // convenience methods...
  void getSelectedArticles( TQValueList<KNArticle*> &l );
  void getSelectedArticles( TQValueList<KNRemoteArticle*> &l );
  void getSelectedThreads( TQValueList<KNRemoteArticle*> &l );
  void getSelectedArticles( TQValueList<KNLocalArticle*> &l );
  void closeCurrentThread();

  //GUI
  TDEAccel          *a_ccel;
  KNProgress      *p_rogBar;
  KNode::ArticleWidget *mArticleViewer;
  KNCollectionView *c_olView;
  KNHeaderView      *h_drView;
  KDockWidget     *c_olDock, *h_drDock, *a_rtDock;
  bool b_lockui;
  TDEToolBar        *q_uicksearch;
  TQLineEdit       *s_earchLineEdit;

  //Core
  KNConfigManager   *c_fgManager;
  KNNetAccess       *n_etAccess;
  KNAccountManager  *a_ccManager;
  KNGroupManager    *g_rpManager;
  KNArticleManager  *a_rtManager;
  KNArticleFactory  *a_rtFactory;
  KNFolderManager   *f_olManager;
  KNFilterManager   *f_ilManager;
  KNScoringManager  *s_coreManager;
  KNMemoryManager   *m_emManager;
  Kpgp::Module      *p_gp;

protected slots:
  //listview slots
  void slotArticleSelected(TQListViewItem*);
  void slotArticleSelectionChanged();
  void slotCollectionSelected(TQListViewItem*);
  void slotCollectionRenamed(TQListViewItem*);
  void slotCollectionViewDrop(TQDropEvent* e, KNCollectionViewItem* after);
  void slotArticleRMB(TDEListView*, TQListViewItem *i, const TQPoint &p);
  void slotCollectionRMB(TDEListView*, TQListViewItem *i, const TQPoint &p);
  /** Open selected article in own composer/reader window */
  void slotOpenArticle(TQListViewItem *item);
  void slotHdrViewSortingChanged(int i);

  //network slots
  void slotNetworkActive(bool b);

  //dock widget slots
  void slotCheckDockWidgeStatus();
  void slotGroupDockHidden();
  void slotHeaderDockHidden();
  void slotArticleDockHidden();
  void slotDockWidgetFocusChangeRequest(TQWidget *w);

  //---------------------------------- <Actions> ----------------------------------

protected:

  //navigation
  TDEAction   *a_ctNavNextArt,
    *a_ctNavPrevArt,
    *a_ctNavNextUnreadArt,
    *a_ctNavNextUnreadThread,
    *a_ctNavNextGroup,
    *a_ctNavPrevGroup,
    *a_ctNavReadThrough;

  //collection-view - accounts
  TDEAction   *a_ctAccProperties,
    *a_ctAccRename,
    *a_ctAccSubscribe,
    *a_ctAccExpireAll,
    *a_ctAccGetNewHdrs,
    *a_ctAccGetNewHdrsAll,
    *a_ctAccDelete,
    *a_ctAccPostNewArticle;

  //collection-view - groups
  TDEAction   *a_ctGrpProperties,
    *a_ctGrpRename,
    *a_ctGrpGetNewHdrs,
    *a_ctGrpExpire,
    *a_ctGrpReorganize,
    *a_ctGrpUnsubscribe,
    *a_ctGrpSetAllRead,
    *a_ctGrpSetAllUnread,
    *a_ctGrpSetUnread;

  //collection-view - folder
  TDEAction   *a_ctFolNew,
    *a_ctFolNewChild,
    *a_ctFolDelete,
    *a_ctFolRename,
    *a_ctFolCompact,
    *a_ctFolCompactAll,
    *a_ctFolEmpty,
    *a_ctFolMboxImport,
    *a_ctFolMboxExport;

  //header-view - list-handling
  TDESelectAction         *a_ctArtSortHeaders;
  KNFilterSelectAction  *a_ctArtFilter;
  TDEAction               *a_ctArtSortHeadersKeyb,
    *a_ctArtFilterKeyb,
    *a_ctArtSearch,
    *a_ctArtRefreshList,
    *a_ctArtCollapseAll,
    *a_ctArtExpandAll,
    *a_ctArtToggleThread;
  TDEToggleAction         *a_ctArtToggleShowThreads;

  //header-view - remote articles
  TDEAction *a_ctArtSetArtRead,
    *a_ctArtSetArtUnread,
    *a_ctArtSetThreadRead,
    *a_ctArtSetThreadUnread,
    *a_ctArtOpenNewWindow;

  // scoring
  TDEAction *a_ctScoresEdit,
    *a_ctReScore,
    *a_ctScoreLower,
    *a_ctScoreRaise,
    *a_ctArtToggleIgnored,
    *a_ctArtToggleWatched;

  //header-view local articles
  TDEAction *a_ctArtSendOutbox,
    *a_ctArtDelete,
    *a_ctArtSendNow,
    *a_ctArtEdit;

  //network
  TDEAction *a_ctNetCancel;

  TDEAction *a_ctFetchArticleWithID;

  // settings menu
  TDEToggleAction *a_ctToggleGroupView,
    *a_ctToggleHeaderView,
    *a_ctToggleArticleViewer,
    *a_ctToggleQuickSearch;
  TDEAction *a_ctSwitchToGroupView,
    *a_ctSwitchToHeaderView,
    *a_ctSwitchToArticleViewer;

protected slots:
  void slotNavNextUnreadArt();
  void slotNavNextUnreadThread();
  void slotNavReadThrough();

  void slotAccProperties();
  void slotAccRename();
  void slotAccSubscribe();
  void slotAccExpireAll();
  void slotAccGetNewHdrs();
  void slotAccGetNewHdrsAll();
  void slotAccDelete();
  void slotAccPostNewArticle();

  void slotGrpProperties();
  void slotGrpRename();
  void slotGrpGetNewHdrs();
  void slotGrpExpire();
  void slotGrpReorganize();
  void slotGrpUnsubscribe();
  void slotGrpSetAllRead();
  void slotGrpSetAllUnread();
  void slotGrpSetUnread();

  void slotFolNew();
  void slotFolNewChild();
  void slotFolDelete();
  void slotFolRename();
  void slotFolCompact();
  void slotFolCompactAll();
  void slotFolEmpty();
  void slotFolMBoxImport();
  void slotFolMBoxExport();

  void slotArtSortHeaders(int i);
  void slotArtSortHeadersKeyb();
  void slotArtSearch();
  void slotArtRefreshList();
  void slotArtCollapseAll();
  void slotArtExpandAll();
  void slotArtToggleThread();
  void slotArtToggleShowThreads();

  void slotArtSetArtRead();
  void slotArtSetArtUnread();
  void slotArtSetThreadRead();
  void slotArtSetThreadUnread();

  void slotScoreEdit();
  void slotReScore();
  void slotScoreLower();
  void slotScoreRaise();
  void slotArtToggleIgnored();
  void slotArtToggleWatched();

  void slotArtOpenNewWindow();
  void slotArtSendOutbox();
  void slotArtDelete();
  void slotArtSendNow();
  void slotArtEdit();

  void slotNetCancel();

  void slotFetchArticleWithID();

  void slotToggleGroupView();
  void slotToggleHeaderView();
  void slotToggleArticleViewer();
  void slotToggleQuickSearch();
  void slotSwitchToGroupView();
  void slotSwitchToHeaderView();
  void slotSwitchToArticleViewer();
  void slotSettings();

  //--------------------------- </Actions> -----------------------------

private:
  KRSqueezedTextLabel *s_tatusGroup; // widget used in the statusBar() for the group status
  KRSqueezedTextLabel *s_tatusFilter;
  KXMLGUIClient *m_GUIClient;
};


class  FetchArticleIdDlg : public KDialogBase
{
    Q_OBJECT
  
public:
    FetchArticleIdDlg(TQWidget *parent, const char */*name*/ );
    TQString messageId() const;

protected slots:
    void slotTextChanged(const TQString & );
protected:
    KLineEdit *edit;
};

#endif
