/*
 * Copyright (C) 2004, Mart Kelder (mart.kde@hccnet.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "tdeio_read.h"

#include "tdeio.h"
#include "tdeio_proto.h"
#include "mailid.h"
#include "stringid.h"

#include <kdebug.h>
#include <tdelocale.h>
#include <kurl.h>
#include <tdeio/global.h>
#include <tdeio/jobclasses.h>
#include <tdeio/scheduler.h>

#include <tqcstring.h>
#include <tqstring.h>

TDEIO_Read::TDEIO_Read( TQObject * parent, const char * name )
	: TQObject( parent, name ),
	_job( 0 ),
	_message( 0 )
{
	_message = new TQString;
}

TDEIO_Read::~TDEIO_Read()
{
	delete _message;
	delete _job;
}

void TDEIO_Read::readMail( const KornMailId *& mailid, KKioDrop* drop )
{
	_tdeio = drop;
	KURL kurl = *_tdeio->_kurl;
	TDEIO::MetaData metadata = *_tdeio->_metadata;
	
	kurl = dynamic_cast<const KornStringId*>(mailid)->getId( );
	
	_tdeio->_protocol->readMailKURL( kurl, metadata );
	
	_job = TDEIO::get( kurl, false, false );
	_job->addMetaData( metadata );
	
	connect( _job, TQT_SIGNAL( result( TDEIO::Job* ) ), this, TQT_SLOT( slotResult( TDEIO::Job* ) ) );
	connect( _job, TQT_SIGNAL( data( TDEIO::Job*, const TQByteArray& ) ), this, TQT_SLOT( slotData( TDEIO::Job*, const TQByteArray & ) ) );
}

void TDEIO_Read::canceled( )
{
	if( _job )
		delete _job;
	_job = 0;
}

void TDEIO_Read::slotResult( TDEIO::Job* job )
{
	if( job != _job )
		kdWarning() << i18n( "Unknown job returned; I will try if this one will do... " ) << endl;

	if( job->error() )
		kdWarning() << i18n( "An error occurred when fetching the requested email: %1." ).arg( job->errorString() ) << endl;
		
	_tdeio->emitReadMailReady( _message );
	
	*_message = "";
	_job = 0;
}

void TDEIO_Read::slotData( TDEIO::Job* job, const TQByteArray & data )
{
	if( job != _job )
		kdWarning() << i18n( "Unknown job returned; I will try if this one will do... " ) << endl;
	
	if( !data.isEmpty() )
		_message->append( data );
}

#include "tdeio_read.moc"
