/*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/
#ifndef TDEABC_RESOURCEGROUPWARE_H
#define TDEABC_RESOURCEGROUPWARE_H

#include <tdeabcresourcecached.h>

#include <libtdepim/progressmanager.h>

#include <tdeio/job.h>

class TDEConfig;

namespace TDEABC {

class GroupwarePrefs;

class ResourceGroupware : public ResourceCached
{
  Q_OBJECT
  

  public:
    ResourceGroupware( const TDEConfig * );
    ResourceGroupware( const KURL &url,
                       const TQString &user, const TQString &password );
    ~ResourceGroupware();

    void readConfig( const TDEConfig * );
    void writeConfig( TDEConfig * );

    void readAddressBooks();
    void writeAddressBooks();

    void retrieveAddressBooks();

    GroupwarePrefs *prefs() const { return mPrefs; }

    bool doOpen();
    void doClose();

    Ticket *requestSaveTicket();
    void releaseSaveTicket( Ticket* );

    bool load();
    bool asyncLoad();
    bool save( Ticket * );
    bool asyncSave( Ticket * );

  protected:
    void init();

  private slots:
    void slotJobResult( TDEIO::Job * );
    void slotJobData( TDEIO::Job *, const TQByteArray & );
    void slotJobPercent( TDEIO::Job *job, unsigned long percent );

    void cancelLoad();

  private:
    GroupwarePrefs *mPrefs;

    TDEIO::TransferJob *mDownloadJob;
    KPIM::ProgressItem *mProgress;
    TQString mJobData;
};

}

#endif
