#include <tqcombobox.h>
#include <ktextedit.h>
#include <kinputdialog.h>
#include <tqlayout.h>
#include <tqlabel.h>

#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kdebug.h>

#include "kbbprefs.h"

#include "messageeditor.h"
#include <tqpushbutton.h>
#include "messageeditor.moc"

MessageEditor::MessageEditor( TQWidget *parent )
  : KDialogBase(Plain,i18n("Edit Message Buttons"),Ok|Cancel,Ok,parent,0,
                true,true)
{
  TQFrame *topFrame = plainPage();
  TQBoxLayout *topLayout = new TQVBoxLayout(topFrame,0,spacingHint());

  TQBoxLayout *selectionLayout = new TQHBoxLayout;
  topLayout->addLayout(selectionLayout);

  TQLabel *selectionLabel = new TQLabel(i18n("Button:"),topFrame);
  selectionLayout->addWidget(selectionLabel);

  mSelectionCombo = new TQComboBox(topFrame);
  selectionLayout->addWidget(mSelectionCombo);
  connect(mSelectionCombo,TQT_SIGNAL(activated(int)),TQT_SLOT(changeMessage()));

  TQPushButton *addButton = new TQPushButton(i18n("Add Button..."),topFrame);
  selectionLayout->addWidget(addButton);
  connect(addButton,TQT_SIGNAL(clicked()),TQT_SLOT(addButton()));

  TQPushButton *removeButton = new TQPushButton(i18n("Remove Button"),topFrame);
  selectionLayout->addWidget(removeButton);
  connect(removeButton,TQT_SIGNAL(clicked()),TQT_SLOT(removeButton()));

  mMessageEdit = new KTextEdit(topFrame);
  topLayout->addWidget(mMessageEdit,1);

  updateConfig();
}

void MessageEditor::updateConfig()
{
  mMessageButtons = KBBPrefs::instance()->mMessageButtons;

  mSelectionCombo->clear();

  TQMap<TQString,TQString>::ConstIterator it;
  for(it = mMessageButtons.begin();it != mMessageButtons.end();++it) {
    mSelectionCombo->insertItem(it.key());
  }

  updateMessage();
}

void MessageEditor::addButton()
{
  TQString txt;
  txt = KInputDialog::getText(i18n("Add Message Button"),
	i18n("Enter button name:"), TQString(),
	NULL, this );

  if ( !txt.isNull() ) {
    saveMessage();
    mSelectionCombo->insertItem(txt);
    mMessageButtons.insert(txt,"");
    mSelectionCombo->setCurrentItem(mSelectionCombo->count()-1);
    updateMessage();
  }

}

void MessageEditor::removeButton()
{
  int result = KMessageBox::warningContinueCancel(this,
      i18n("Remove the button %1?").arg(mSelectionCombo->currentText()),
      i18n("Remove"), KGuiItem( i18n("Delete"), "edit-delete") );

  if (result == KMessageBox::Continue) {
    mMessageButtons.remove(mSelectionCombo->currentText());
    mSelectionCombo->removeItem(mSelectionCombo->currentItem());
    mSelectionCombo->setCurrentItem(0);
    updateMessage();
  }
}

void MessageEditor::changeMessage()
{
  saveMessage();
  updateMessage();
}

void MessageEditor::updateMessage()
{
  mCurrentButton = mSelectionCombo->currentText();

  mMessageEdit->setText(mMessageButtons[mCurrentButton]);
}

void MessageEditor::saveMessage()
{
  mMessageButtons.replace(mCurrentButton,mMessageEdit->text());
}

void MessageEditor::slotOk()
{
  saveMessage();

  KBBPrefs::instance()->mMessageButtons = mMessageButtons;
  accept();
}
