/***************************************************************************
 *   Copyright (C) 2006-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#include "opencontextmenu.h"

#include <krun.h>
#include <tdelocale.h>

OpenContextmenu::OpenContextmenu(const KURL&aPath,const TDETrader::OfferList&aList,TQWidget* parent, const char* name)
    : TQPopupMenu(parent, name),m_Path(aPath),m_List(aList)
{
    setup();
}

OpenContextmenu::~OpenContextmenu()
{
}

void OpenContextmenu::setup()
{
    m_mapPopup.clear();
    TDETrader::OfferList::ConstIterator it = m_List.begin();
    int id = 1;
    TDEAction*act;
    for( ; it != m_List.end(); ++it ) {
        if ((*it)->noDisplay())
            continue;

        TQCString nam;
        nam.setNum( id );

        TQString actionName( (*it)->name().replace("&", "&&") );
        act = new TDEAction( actionName, (*it)->pixmap( TDEIcon::Small ), 0,
                                    TQT_TQOBJECT(this), TQT_SLOT( slotRunService() ), TQT_TQOBJECT(this), nam.prepend( "appservice_" ) );
        act->plug(this);
        m_mapPopup[ id++ ] = *it;
    }
    if (m_List.count()>0) {
        insertSeparator( );
    }
    act = new TDEAction(i18n("Other..."),0, 0,
        TQT_TQOBJECT(this), TQT_SLOT( slotOpenWith() ),TQT_TQOBJECT(this),"openwith");
    act->plug(this);
}

void OpenContextmenu::slotRunService()
{
  TQCString senderName = TQT_TQOBJECT(const_cast<TQT_BASE_OBJECT_NAME*>(sender()))->name();
  int id = senderName.mid( senderName.find( '_' ) + 1 ).toInt();

  TQMap<int,KService::Ptr>::Iterator it = m_mapPopup.find( id );
  if ( it != m_mapPopup.end() )
  {
    KRun::run( **it, m_Path );
    return;
  }

}

void OpenContextmenu::slotOpenWith()
{
    KURL::List lst;
    lst.append(m_Path);
    KRun::displayOpenWithDialog(lst);
}

#include "opencontextmenu.moc"
