/*
    This file is part of KWeather.
    Copyright (c) 2004 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef STATIONSCONFIGWIDGET_H
#define STATIONSCONFIGWIDGET_H

#include <stationsconfig.h>

class TQListViewItem;
class WeatherService_stub;

class StationsConfigWidget : public stationsConfig
{
  Q_OBJECT
  

  public:
    StationsConfigWidget( TQWidget *parent, const char *name = 0 );
    virtual ~StationsConfigWidget();

  signals:
    void changed( bool );

  public slots:
    void addStation();
    void removeStation();
    void updateStations();
    void exitWeatherService();

    void selectionChanged( TQListViewItem* );
    void modified();

  private:
    void initGUI();
    void loadLocations();
    bool dcopActive();
    void scanStations();

    TQMap<TQString, TQString> mStationMap;
    WeatherService_stub *mService;
};

#endif
