/* Copyright (C) 2003 Oliver Kellogg
 * okellogg@users.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */
#ifndef ADAGLOBALOPTIONSDLG_H
#define ADAGLOBALOPTIONSDLG_H

#include <tqmap.h>

#include <ktrader.h>

#include "adaproject_optionsdlgbase.h"

class AdaProjectPart;

class AdaGlobalOptionsDlg : public AdaProjectOptionsDlgBase
{
    Q_OBJECT
  

public:
    AdaGlobalOptionsDlg(AdaProjectPart *part, TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~AdaGlobalOptionsDlg();

public slots:
    virtual void accept();

protected slots:
    virtual void optionsButtonClicked();
    virtual void compiler_box_activated(const TQString& text);

private:
    AdaProjectPart *m_part;
    TDETrader::OfferList offers;
    TQString currentCompiler;
    TQStringList service_names;
    TQStringList service_execs;
    TQMap<TQString, TQString> configCache;

    void saveCompilerOpts(TQString compiler);
    void readCompilerOpts(TQString compiler);

    void readConfigCache();
    void saveConfigCache();
};

#endif
