/***************************************************************************
*   Copyright (C) 2001 by Bernd Gehrmann                                  *
*   bernd@kdevelop.org                                                    *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef _ADDPREFIXDLG_H_
#define _ADDPREFIXDLG_H_

#include <tqdialog.h>
#include <klineedit.h>
class TQPushButton;

class AddPrefixDialog : public TQDialog
{
	Q_OBJECT
  

public:
	AddPrefixDialog( const TQString& nameEdit = "", const TQString& pathEdit = "",
	                 TQWidget *parent = 0, const char *name = 0 );
	~AddPrefixDialog();

	TQString name() const
	{
		return name_edit->text();
	}
	TQString path() const
	{
		return path_edit->text();
	}
private slots:
	void slotPrefixChanged();

private:
	KLineEdit *name_edit;
	KLineEdit *path_edit;
	TQPushButton *m_pOk;
};

#endif
