/**********************************************************************
** Copyright (C) 2002 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef STARTDIALOGIMPL_H
#define STARTDIALOGIMPL_H

#include <tqiconview.h>
#include <tqlistview.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqfiledialog.h>
#include <tqmap.h>

#include "newformimpl.h"
#include "startdialog.h"

class FileDialog : public TQFileDialog
{
    Q_OBJECT
  

public:
    FileDialog( const TQString &dir, TQWidget *parent );

protected slots:
    void accept();

signals:
    void fileSelected();
};


class StartDialog : public StartDialogBase
{
    Q_OBJECT
  

public:
    StartDialog( TQWidget *parent, const TQString &templatePath );
    void setRecentlyFiles( TQStringList& );
    void setRecentlyProjects( TQStringList& );
    bool showDialogInFuture() const { return showInFuture; }

protected slots:
    void recentItemChanged( TQIconViewItem *item );
    void clearFileInfo();
    void accept();
    void reject();

private:
    void initFileOpen();
    void insertRecentItems( TQStringList &files, bool isProject );
    NewForm *newForm;
    FileDialog *fd;
    TQMap<int, TQString> recentFiles;
    bool showInFuture;
};

#endif
