
#include "%{APPNAMELC}.h"

#include <kkeydialog.h>
#include <tdefiledialog.h>
#include <tdeconfig.h>
#include <kurl.h>

#include <kedittoolbar.h>

#include <tdeaction.h>
#include <kstdaction.h>

#include <klibloader.h>
#include <tdemessagebox.h>
#include <kstatusbar.h>
#include <tdelocale.h>

%{APPNAME}::%{APPNAME}()
    : KParts::MainWindow( 0L, "%{APPNAME}" )
{
    // set the shell's ui resource file
    setXMLFile("%{APPNAMELC}_shell.rc");

    // then, setup our actions
    setupActions();

    // and a status bar
    statusBar()->show();

    // this routine will find and load our Part.  it finds the Part by
    // name which is a bad idea usually.. but it's alright in this
    // case since our Part is made for this Shell
    KLibFactory *factory = KLibLoader::self()->factory("lib%{APPNAMELC}part");
    if (factory)
    {
        // now that the Part is loaded, we cast it to a Part to get
        // our hands on it
        m_part = static_cast<KParts::ReadWritePart *>(factory->create(this,
                                "%{APPNAMELC}_part", "KParts::ReadWritePart" ));

        if (m_part)
        {
            // tell the KParts::MainWindow that this is indeed the main widget
            setCentralWidget(m_part->widget());

            // and integrate the part's GUI with the shell's
            createGUI(m_part);
        }
    }
    else
    {
        // if we couldn't find our Part, we exit since the Shell by
        // itself can't do anything useful
        KMessageBox::error(this, i18n("Could not find our part."));
        kapp->quit();
        // we return here, cause kapp->quit() only means "exit the
        // next time we enter the event loop...
        return;
    }

    // apply the saved mainwindow settings, if any, and ask the mainwindow
    // to automatically save settings if changed: window size, toolbar
    // position, icon size, etc.
    setAutoSaveSettings();
}

%{APPNAME}::~%{APPNAME}()
{
}

void %{APPNAME}::load(const KURL& url)
{
    m_part->openURL( url );
}

void %{APPNAME}::setupActions()
{
    KStdAction::openNew(this, TQT_SLOT(fileNew()), actionCollection());
    KStdAction::open(this, TQT_SLOT(fileOpen()), actionCollection());

    KStdAction::quit(kapp, TQT_SLOT(quit()), actionCollection());

    m_toolbarAction = KStdAction::showToolbar(this, TQT_SLOT(optionsShowToolbar()), actionCollection());
    m_statusbarAction = KStdAction::showStatusbar(this, TQT_SLOT(optionsShowStatusbar()), actionCollection());

    KStdAction::keyBindings(this, TQT_SLOT(optionsConfigureKeys()), actionCollection());
    KStdAction::configureToolbars(this, TQT_SLOT(optionsConfigureToolbars()), actionCollection());
}

void %{APPNAME}::saveProperties(TDEConfig* /*config*/)
{
    // the 'config' object points to the session managed
    // config file.  anything you write here will be available
    // later when this app is restored
}

void %{APPNAME}::readProperties(TDEConfig* /*config*/)
{
    // the 'config' object points to the session managed
    // config file.  this function is automatically called whenever
    // the app is being restored.  read in here whatever you wrote
    // in 'saveProperties'
}

void %{APPNAME}::fileNew()
{
    // this slot is called whenever the File->New menu is selected,
    // the New shortcut is pressed (usually CTRL+N) or the New toolbar
    // button is clicked

    // About this function, the style guide (
    // http://developer.kde.org/documentation/standards/kde/style/basics/index.html )
    // says that it should open a new window if the document is _not_
    // in its initial state.  This is what we do here..
    if ( ! m_part->url().isEmpty() || m_part->isModified() )
    {
        (new %{APPNAME})->show();
    };
}


void %{APPNAME}::optionsShowToolbar()
{
    // this is all very cut and paste code for showing/hiding the
    // toolbar
    if (m_toolbarAction->isChecked())
        toolBar()->show();
    else
        toolBar()->hide();
}

void %{APPNAME}::optionsShowStatusbar()
{
    // this is all very cut and paste code for showing/hiding the
    // statusbar
    if (m_statusbarAction->isChecked())
        statusBar()->show();
    else
        statusBar()->hide();
}

void %{APPNAME}::optionsConfigureKeys()
{
    KKeyDialog::configure(actionCollection());
}

void %{APPNAME}::optionsConfigureToolbars()
{
#if defined(TDE_MAKE_VERSION)
# if TDE_VERSION >= TDE_MAKE_VERSION(3,1,0)
    saveMainWindowSettings(TDEGlobal::config(), autoSaveGroup());
# else
    saveMainWindowSettings(TDEGlobal::config() );
# endif
#else
    saveMainWindowSettings(TDEGlobal::config() );
#endif

    // use the standard toolbar editor
    KEditToolbar dlg(factory());
    connect(&dlg, TQT_SIGNAL(newToolbarConfig()),
            this, TQT_SLOT(applyNewToolbarConfig()));
    dlg.exec();
}

void %{APPNAME}::applyNewToolbarConfig()
{
#if defined(TDE_MAKE_VERSION)
# if TDE_VERSION >= TDE_MAKE_VERSION(3,1,0)
    applyMainWindowSettings(TDEGlobal::config(), autoSaveGroup());
# else
    applyMainWindowSettings(TDEGlobal::config());
# endif
#else
    applyMainWindowSettings(TDEGlobal::config());
#endif
}

void %{APPNAME}::fileOpen()
{
    // this slot is called whenever the File->Open menu is selected,
    // the Open shortcut is pressed (usually CTRL+O) or the Open toolbar
    // button is clicked
    KURL url =
        KFileDialog::getOpenURL( TQString(), TQString(), this );

    if (url.isEmpty() == false)
    {
        // About this function, the style guide (
        // http://developer.kde.org/documentation/standards/kde/style/basics/index.html )
        // says that it should open a new window if the document is _not_
        // in its initial state.  This is what we do here..
        if ( m_part->url().isEmpty() && ! m_part->isModified() )
        {
            // we open the file in this window...
            load( url );
        }
        else
        {
            // we open the file in a new window...
            %{APPNAME}* newWin = new %{APPNAME};
            newWin->load( url );
            newWin->show();
        }
    }
}

#include "%{APPNAMELC}.moc"
