#ifndef %{APPNAMEUC}_H
#define %{APPNAMEUC}_H


/**
 * Opie and TQtopia uses a component system called TQCOM
 * which was first part of the TQt 3.0 API but was made
 * prviate during the betas. Opie and TQtopia still use it
 * and we're happy with it.
 * Every starts with the TQUnknownInterface. It supports functions
 * for reference counting and the most important one
 * is for a query. Every TQCOM interface got a global unique id ( GUID,UUID )
 * query is used to see if a interface is supported by
 * a dynamic shared object ( dso / plugin )
 * For tasks like loading Applications, InputMethods, Today, MenuButton,
 * Taskbar, Style, Email Client there are specefic Interfaces you
 * need to implement. The interfaces inherits from TQUnknownInterface and
 * you'll need inherit from the interface.
 * As example we will use the Taskbar interface
 */


/*
 * The taskbar applet interfaces wants us to implement position() and applet()
 * additionally we need to implement add(), release() and queryInterface for TQUnknownInterface
 * luckiy there is a macro for the reference counting
 * We provide an Implementation of the interface.
 */
#include <tqwidget.h>
#include <tqptrlist.h>

#include <tqpe/taskbarappletinterface.h>


/*
 * Because we only draw an Icon in a fixed width and height
 * we declare and define  %{APPNAME} here and you could use TQLabel
 * setPixmap or use TQWidget and draw yourself.
 * You might also want to reimplement mouse*Event to use some simple actions
 */
class  %{APPNAME} : public TQWidget {
    Q_OBJECT
  
public:
     %{APPNAME}(TQWidget *parent);
    ~%{APPNAME}();
private:
    void mousePressEvent( TQMouseEvent* );
    void paintEvent( TQPaintEvent* );
    TQPixmap *m_pix;
};

class %{APPNAME}Impl : public TaskbarAppletInterface {
public:

    %{APPNAME}Impl();
    virtual ~%{APPNAME}Impl();

    TQRESULT queryInterface( const TQUuid&, TQUnknownInterface** );

    TQWidget *applet( TQWidget* parent );
    int position()const;

    /*
     * macro for reference countint
     * if reference drops to zero
     * delete this is called
     */
    TQ_REFCOUNT

private:
    TQPtrList<%{APPNAME}> m_applets;
};


#endif
