/*
   Copyright (C) 2002 by Roberto Raggi <roberto@kdevelop.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   version 2, License as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef PROBLEMSREPORTER_H
#define PROBLEMSREPORTER_H

#include <tdelistview.h>
#include <tqguardedptr.h>

class JavaSupportPart;
class TQTimer;
class KDialogBase;
class Problem;

namespace KParts{
    class Part;
}

namespace KTextEditor{
    class MarkInterface;
    class Document;
}

class ProblemReporter: public TDEListView{
    Q_OBJECT
  
public:
    ProblemReporter( JavaSupportPart* part, TQWidget* parent=0, const char* name=0 );
    virtual ~ProblemReporter();

    void removeAllProblems( const TQString& filename );
    void reportProblem( const TQString& fileName, const Problem& p );

public slots:
    void reparse();
    void configure();
    void configWidget( KDialogBase* );

private slots:
    void slotPartAdded( KParts::Part* );
    void slotPartRemoved( KParts::Part* );
    void slotActivePartChanged( KParts::Part* );
    void slotTextChanged();
    void slotSelected( TQListViewItem* );

private:
    TQString levelToString( int level ) const;
    int levelToMarkType( int level ) const;

private:
    JavaSupportPart* m_javaSupport;
    TQGuardedPtr<KTextEditor::Document> m_document;
    KTextEditor::MarkInterface* m_markIface;
    TQTimer* m_timer;
    TQString m_fileName;
    int m_active;
    int m_delay;
};

#endif
