//
// C++ Interface: jscodecompletion
//
// Description:
//
//
// Author: ian reinhart geiser <geiseri@kde.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef JSCODECOMPLETION_H
#define JSCODECOMPLETION_H

#include <tqobject.h>
#include <tdevelop/codemodel.h>
#include <tdevelop/kdevplugin.h>
#include <tdevelop/kdevlanguagesupport.h>

#include <tdetexteditor/editinterface.h>
#include <tdetexteditor/viewcursorinterface.h>
#include <tdetexteditor/codecompletioninterface.h>

/**
The code completion engine for Javascript.
 
@author ian reinhart geiser
*/
class JSCodeCompletion : public TQObject
{
		Q_OBJECT
  
	public:
		JSCodeCompletion(TQObject *parent = 0, const char *name = 0);

		~JSCodeCompletion();
		void setActiveEditorPart(KParts::Part* editorPart);
		TQValueList<KTextEditor::CompletionEntry> getVars(const TQString& textHint);

	public slots:
		void cursorPositionChanged();
		void completionBoxHidden();
		void completionBoxAbort();

	private:
		bool m_argWidgetShow;
		bool m_completionBoxShow;
		KTextEditor::EditInterface *m_editInterface;
		KTextEditor::CodeCompletionInterface *m_codeInterface;
		KTextEditor::ViewCursorInterface *m_cursorInterface;

};

#endif
