/***************************************************************************
 *   Copyright (C) 2002 Roberto Raggi                                      *
 *   roberto@kdevelop.org                                                  *
 *   Copyright (C) 2002 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *   Copyright (C) 2003 by Alexander Dymo                                  *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "abbrevconfigwidget.h"

#include <tdeconfig.h>
#include <kiconloader.h>

#include <tqlistview.h>
#include <tqmultilineedit.h>
#include <tqcheckbox.h>

#include "addtemplatedlg.h"
#include "abbrevpart.h"

AbbrevConfigWidget::AbbrevConfigWidget(AbbrevPart *part, TQWidget *parent, const char *name)
    : AbbrevConfigWidgetBase(parent, name)
{
    m_part = part;

    tqWarning("creating abbrevconfigwidget for %d abbrevs", part->templates().allTemplates().count());
    TQPtrList<CodeTemplate> templates = part->templates().allTemplates();
    CodeTemplate *templ;
    for (templ = templates.first(); templ; templ = templates.next())
    {
        tqWarning("creating item for code template ");
        TQListViewItem *it = new TQListViewItem( listTemplates,
                           templ->name,
                           templ->description,
                           templ->suffixes,
                           templ->code,
                           templ->code );
        it->setPixmap( 0, SmallIcon("application-vnd.tde.template_source"));
    }

    checkWordCompletion->setChecked( part->autoWordCompletionEnabled() );
    listTemplates->setSorting(2);
}


AbbrevConfigWidget::~AbbrevConfigWidget()
{}


void AbbrevConfigWidget::addTemplate()
{
    TQStringList suffixesList = m_part->templates().suffixes();

    AddTemplateDialog dlg( suffixesList, this );
    if( dlg.exec() ){
        TQString templ = dlg.templ();
        TQString description = dlg.description();
        TQString suffixes = dlg.suffixes();
        if( !(templ.isEmpty() || description.isEmpty()) || suffixes.isEmpty()) {
            TQListViewItem* item = new TQListViewItem( listTemplates, templ, description, suffixes );
            listTemplates->setSelected( item, true );
            editCode->setFocus();
        }
    }
}


void AbbrevConfigWidget::removeTemplate()
{
    if (!listTemplates->selectedItem())
        return;
    delete listTemplates->selectedItem();
}


void AbbrevConfigWidget::selectionChanged()
{
    TQListViewItem* item = listTemplates->selectedItem();
    if( item ){
        editCode->setText( item->text(3) );
    }
}


void AbbrevConfigWidget::codeChanged()
{
    TQListViewItem* item = listTemplates->selectedItem();
    if( item ){
        item->setText( 3, editCode->text() );
        if (item->text(3) == item->text(4))
            item->setPixmap( 0, SmallIcon("application-vnd.tde.template_source") );
        else
            item->setPixmap( 0, SmallIcon("document-save") );
    }
}


void AbbrevConfigWidget::accept()
{
    m_part->clearTemplates();

    TQListViewItem* item = listTemplates->firstChild();
    while( item ){
        m_part->addTemplate( item->text(0),
                             item->text(1),
                             item->text(2),
                             item->text(3) );
        item = item->nextSibling();
    }

    m_part->setAutoWordCompletionEnabled( checkWordCompletion->isChecked() );
}

#include "abbrevconfigwidget.moc"
