/*
 *  Copyright (C) 2001 Matthias H�zer-Klpfel <mhk@caldera.de>
 */


#ifndef __KDEVPART_ASTYLE_H__
#define __KDEVPART_ASTYLE_H__

class KDialogBase;
#include <kdevsourceformatter.h>
#include <tdeaction.h>
#include <tdeparts/part.h>
#include <kdevplugin.h>
#include <kdebug.h>
#include <tqmap.h>
#include <tqvariant.h>

class AStyleWidget;
class TQPopupMenu;
class Context;
class ConfigWidgetProxy;

class AStylePart : public KDevSourceFormatter
{
  Q_OBJECT
  

public:

  AStylePart(TQObject *parent, const char *name, const TQStringList &);
  ~AStylePart();

  TQString formatSource(const TQString text, AStyleWidget * widget, const TQStringVariantMap& options);
  virtual TQString formatSource(const TQString text);
  TQString indentString() const;
  void saveGlobal();
  void setExtensions(TQString ext, bool global);
  TQString getProjectExtensions();
  TQString getGlobalExtensions();
  void restorePartialProjectSession(const TQDomElement * el);
  void savePartialProjectSession(TQDomElement * el);

  TQStringVariantMap& getProjectOptions(){return m_project;}
  TQStringVariantMap& getGlobalOptions(){return m_global;}


private slots:

  void activePartChanged(KParts::Part *part);
  void beautifySource();
  void formatFiles();
  void formatFilesSelect();
  void insertConfigWidget(const KDialogBase *dlg, TQWidget *page, unsigned int pageNo);
  void contextMenu(TQPopupMenu *popup, const Context *context);

private:

  void cursorPos( KParts::Part *part, uint * col, uint * line );
  void setCursorPos( KParts::Part *part, uint col, uint line );

  void loadGlobal();

  ConfigWidgetProxy *m_configProxy;
  TDEAction *formatTextAction;
  TDEAction *formatFileAction;

  // the configurable options.
  TQStringVariantMap  m_project;
  TQStringVariantMap m_global;
  TQStringList m_projectExtensions;
  TQStringList m_globalExtensions;
  TQMap<TQString, TQString> m_searchExtensions;
  KURL::List m_urls;
};


#endif
