/***************************************************************************
 *   Copyright (C) 2004 by ian reinhart geiser                             *
 *   geiseri@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "distpart_widget.h"

#include <tdeparts/part.h>
#include <klibloader.h>
#include <kurl.h>
#include <kdebug.h>
#include <kprocess.h>
#include <tdefiledialog.h>
#include <tdeio/netaccess.h>
#include <tdelocale.h>
#include "kdevproject.h"
#include "domutil.h"
#include <ktar.h>
#include <tdemessagebox.h>

#include <kdevcore.h>
#include <tqgroupbox.h>
#include <tqlayout.h>
#include <tqnetwork.h>
#include <tqurloperator.h>
#include <tqmessagebox.h>
#include "distpart_part.h"
#include <tqdir.h>
#include <tqfile.h>
#include <tqregexp.h>
#include <tqstringlist.h>
#include <tqtabwidget.h>
#include "kdevmakefrontend.h"
#include <kprogress.h>

#include <tqerrormessage.h>
#include "specsupport.h"
#include "lsmsupport.h"

DistpartDialog::DistpartDialog(DistpartPart *part, TQWidget *parent)
        :distpart_ui(parent, "dist_widget"), m_part(part) {
    m_spec = new SpecSupport(m_part);

    connect( customProjectCheckBox, TQT_SIGNAL(toggled(bool) ),
            this, TQT_SLOT(slotcustomProjectCheckBoxChanged()));
    connect( uploadCustomCheckBox, TQT_SIGNAL(toggled(bool)),
            this, TQT_SLOT(slotuploadCustomCheckBoxChanged()));

//    connect( okayPushButton, TQT_SIGNAL(clicked()),
//            this, TQT_SLOT(slotokayPushButtonPressed()));
//    connect( cancelPushButton, TQT_SIGNAL(clicked()),
//            this, TQT_SLOT(slotcancelPushButtonPressed()));
/*    connect(help_PushButton, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slothelp_PushButtonPressed()));*/
    connect( createSrcArchPushButton, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotcreateSrcArchPushButtonPressed()));
    connect( resetSrcPushButton, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotresetSrcPushButtonPressed()));

    connect( genHTMLPushButton, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotgenHTMLPushButtonPressed()));
    connect( resetHTMLPushButton, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotresetHTMLPushButtonPressed()));
    connect( uploadSubmitPushButton, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotuploadSubmitPushButtonPressed()));
    connect( uploadResetPushButton, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotuploadResetPushButtonPressed()));
    connect( uploadAddFileToolButton, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotuploadAddFileToolButtonPressed()));
    connect( uploadRemoveToolButton, TQT_SIGNAL(clicked()),
            this, TQT_SLOT(slotuploadRemoveToolButtonPressed()));
	connect ( srcDistFileListBox, TQT_SIGNAL(clicked(TQListBoxItem*)), this, TQT_SLOT(slotRemoveFile(TQListBoxItem*)));
//	connect(  buildAllPushButton, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotbuildAllPushButtonPressed() ));
//	connect(  exportSPECPushButton, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotexportSPECPushButtonPressed( ) ) );
//	connect(  srcPackagePushButton, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotsrcPackagePushButtonPressed() ) );
//	connect(  importSPECPushButton, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotimportSPECPushButtonPressed() ) );
    loadSettings();


     localOptionsGroupBox->setEnabled(false);
     devPackageCheckBox->setEnabled(false);
     docsPackageCheckBox->setEnabled(false);
     appIconCheckBox->setEnabled(false);
     uploadftpkdeorgCheckBox->setEnabled(false);
     uploadAppsKDEcomCheckBox->setEnabled(false);
}


DistpartDialog::~DistpartDialog() {
}

//    TQPushButton* okayPushButton;

void DistpartDialog::slotokayPushButtonPressed() {
    storeSettings();
//    accept();
}
//    TQPushButton* cancelPushButton;

void DistpartDialog::slotcancelPushButtonPressed() {
//    reject();
}
//    TQPushButton* help_PushButton;

/*void DistpartDialog::slothelp_PushButtonPressed() {
    TQMessageBox::about(this,i18n("Distpart Help"),i18n("In order to build a RPM package :\n\t1) Create a source archive\n\t2) Generate a SPEC File\n\t3) Build the package"));
}*/

//    TQPushButton* createSrcArchPushButton;
void DistpartDialog::slotcreateSrcArchPushButtonPressed() {
    kdDebug() << "Starting archive..." << endl;
    TQString dist = (getcustomProjectCheckBoxState() && getbzipCheckBoxState()) ? "application/x-bzip2" : "application/x-gzip";

    TQString filename = m_part->project()->projectDirectory() + "/" + getSourceName();

    KTar tar(filename, dist);
    if ( tar.open(IO_WriteOnly) )
    {
    	//TQStringList files = m_part->project()->distFiles();
	KProgressDialog *prog = new KProgressDialog( 0, "dialog", i18n("Building Package"), "", true );
	prog->show();
	for( uint idx = 0; idx < srcDistFileListBox->numRows(); ++idx)
	{
		TQString file = srcDistFileListBox->text(idx);
		if ( !tar.addLocalFile( m_part->project()->projectDirectory() + "/" + file, getappNameFormatLineEditText() + "/" + file) )
		{
			kdDebug() << "Failed to write file " << file << endl;
		}
		else
		{
			prog->setLabel(i18n("Adding file: %1").arg( file) );
			prog->progressBar()->setValue( (idx*100)/srcDistFileListBox->numRows() );
		}
	}
    	tar.close( );
	prog->hide();
	delete prog;
	KMessageBox::information( this, i18n("Archive made at: %1").arg( filename ), i18n("Archive Done") );

    }
    else
    {
    	kdDebug() << "Failed to open archive..." << endl;
    }

}

//    TQPushButton* resetSrcPushButton;
void DistpartDialog::slotresetSrcPushButtonPressed() {
	srcDistFileListBox->clear();
	loadSettings();
}



//    TQPushButton* genHTMLPushButton;
void DistpartDialog::slotgenHTMLPushButtonPressed() {}

//    TQPushButton* resetHTMLPushButton;
void DistpartDialog::slotresetHTMLPushButtonPressed() {}

//    TQToolButton* uploadAddFileToolButton;
void DistpartDialog::slotuploadAddFileToolButtonPressed() {
     uploadFileListBox->insertStringList(KFileDialog::getOpenFileNames());
}

//    TQToolButton* uploadRemoveToolButton;
void DistpartDialog::slotuploadRemoveToolButtonPressed() {
    for(unsigned int i=0; i<  uploadFileListBox->count(); i++)
	if ( uploadFileListBox->isSelected(i))  uploadFileListBox->removeItem(i);
}

//    TQPushButton* uploadSubmitPushButton;
void DistpartDialog::slotuploadSubmitPushButtonPressed() {

    if(getuploadftpkdeorgCheckBoxState() || getuploadAppsKDEcomCheckBoxState())
        kdDebug() << "Implement ftp.kde.org & apps.kde.com ftp transfer" << endl;
    else {
        for(unsigned int i=0; i< uploadFileListBox->count(); i++)
	    TDEIO::NetAccess::copy(KURL::fromPathOrURL( uploadFileListBox->text(i) ),
                    KURL::fromPathOrURL( getuploadURLLineEditText() +  uploadFileListBox->text(i).replace(TQRegExp("[^/]*/"),"") ));
    }
}

//    TQPushButton* uploadResetPushButton;
void DistpartDialog::slotuploadResetPushButtonPressed() {
     uploadFileListBox->clear();
}

// Connect Slots to the following widgets and add
// accessors and mutators


//    TQCheckBox* customProjectCheckBox;
void DistpartDialog::slotcustomProjectCheckBoxChanged() {
    kdDebug () << "New State" <<  customProjectCheckBox->isChecked() << endl;
     sourceOptionsGroupBox->setEnabled( customProjectCheckBox->isChecked());
}

bool DistpartDialog::getcustomProjectCheckBoxState() {
    return  customProjectCheckBox->isChecked();
}

void DistpartDialog::setcustomProjectCheckBoxState(bool state) {
     customProjectCheckBox->setChecked(state);
}

//  TQCheckBox* uploadCustomCheckBox;
void DistpartDialog::slotuploadCustomCheckBoxChanged() {
     uploadURLLineEdit->setEnabled( uploadCustomCheckBox->isChecked());
}

bool DistpartDialog::getuploadCustomCheckBoxState() {
    return  uploadCustomCheckBox->isChecked();
}

void DistpartDialog::setuploadCustomCheckBoxState(bool state) {
     uploadCustomCheckBox->setChecked(state);
}

// Add accessors and mutators for the following

//   TQCheckBox* bzipCheckBox;
bool DistpartDialog::getbzipCheckBoxState() {
    return  bzipCheckBox->isChecked();
}

void DistpartDialog::setbzipCheckBoxState(bool state) {
     bzipCheckBox->setChecked(state);
}

//    TQCheckBox* appIconCheckBox;
bool DistpartDialog::getappIconCheckBoxState() {
    return  appIconCheckBox->isChecked();
}

void DistpartDialog::setappIconCheckBoxState(bool state) {
     appIconCheckBox->setChecked(state);
}

//    TQCheckBox* genHTMLCheckBox;
bool DistpartDialog::getgenHTMLCheckBoxState() {
    return  genHTMLCheckBox->isChecked();
}

void DistpartDialog::setgenHTMLCheckBoxState(bool state) {
     genHTMLCheckBox->setChecked(state);
}

//    TQCheckBox* useRPMInfoCheckBox;
bool DistpartDialog::getuseRPMInfoCheckBoxState() {
    return  useRPMInfoCheckBox->isChecked();
}

void DistpartDialog::setuseRPMInfoCheckBoxState(bool state) {
     useRPMInfoCheckBox->setChecked(state);
}

//    TQCheckBox* uploadAppsKDEcomCheckBox;
bool DistpartDialog::getuploadAppsKDEcomCheckBoxState() {
    return  uploadAppsKDEcomCheckBox->isChecked();
}

void DistpartDialog::setuploadAppsKDEcomCheckBoxState(bool state) {
     uploadAppsKDEcomCheckBox->setChecked(state);
}

//    TQCheckBox* uploadftpkdeorgCheckBox;
bool DistpartDialog::getuploadftpkdeorgCheckBoxState() {
    return  uploadftpkdeorgCheckBox->isChecked();
}

void DistpartDialog::setuploadftpkdeorgCheckBoxState(bool state) {
     uploadftpkdeorgCheckBox->setChecked(state);
}

//    TQCheckBox* devPackageCheckBox;
bool DistpartDialog::getdevPackageCheckBoxState() {
    return  devPackageCheckBox->isChecked();
}

void DistpartDialog::setdevPackageCheckBoxState(bool state) {
     devPackageCheckBox->setChecked(state);
}

//    TQCheckBox* docsPackageCheckBox;
bool DistpartDialog::getdocsPackageCheckBoxState() {
    return  docsPackageCheckBox->isChecked();
}

void DistpartDialog::setdocsPackageCheckBoxState(bool state) {
     docsPackageCheckBox->setChecked(state);
}

//    TQLineEdit* archNameFormatLineEdit;
TQString DistpartDialog::getarchNameFormatLineEditText() {
    return  archNameFormatLineEdit->text();
}

void DistpartDialog::setarchNameFormatLineEditText(TQString text) {
     archNameFormatLineEdit->setText(text);
}

//    TQLineEdit* appNameLineEdit;
TQString DistpartDialog::getappNameFormatLineEditText() {
    return  appNameLineEdit->text();
}

void DistpartDialog::setappNameFormatLineEditText(TQString text) {
     appNameLineEdit->setText(text);
}

//    TQLineEdit* summaryLineEdit;
TQString DistpartDialog::getsummaryLineEditText() {
    return  summaryLineEdit->text();
}

void DistpartDialog::setsummaryLineEditText(TQString text) {
     summaryLineEdit->setText(text);
}

//    TQLineEdit* groupLineEdit;
TQString DistpartDialog::getgroupLineEditText() {
    return  groupLineEdit->text();
}

void DistpartDialog::setgroupLineEditText(TQString text) {
     groupLineEdit->setText(text);
}

//    TQLineEdit* releaseLineEdit;
TQString DistpartDialog::getreleaseLineEditText() {
    return  releaseLineEdit->text();
}

void DistpartDialog::setreleaseLineEditText(TQString text) {
     releaseLineEdit->setText(text);
}

//    TQLineEdit* VersionLineEdit;
TQString DistpartDialog::getversionLineEditText() {
    return  versionLineEdit->text();
}

void DistpartDialog::setversionLineEditText(TQString text) {
     versionLineEdit->setText( text );
}

//    TQLineEdit* VendorLineEdit;
TQString DistpartDialog::getvendorLineEditText() {
    return  vendorLineEdit->text();
}

void DistpartDialog::setvendorLineEditText(TQString text) {
     vendorLineEdit->setText(text);
}

//    TQLineEdit* LicenseLineEdit;
TQString DistpartDialog::getlicenseLineEditText() {
    return  licenseLineEdit->text();
}

void DistpartDialog::setlicenseLineEditText(TQString text) {
     licenseLineEdit->setText(text);
}

//    TQLineEdit* uploadURLLineEdit;
TQString DistpartDialog::getuploadURLLineEditText() {
    return  uploadURLLineEdit->text();
}

void DistpartDialog::setuploadURLLineEditText(TQString text) {
     uploadURLLineEdit->setText(text);
}

//    TQLineEdit* PackagerLineEdit;
TQString DistpartDialog::getpackagerLineEditText() {
    return  packagerLineEdit->text();
}

void DistpartDialog::setpackagerLineEditText(TQString text) {
     packagerLineEdit->setText(text);
}

//    TQComboBox* archComboBox;
TQString DistpartDialog::getarchComboBoxText() {
    return  archComboBox->currentText();
}

int DistpartDialog::getarchComboBoxItem() {
    return  archComboBox->currentItem();
}

void DistpartDialog::setarchComboBoxItem(int item) {
     archComboBox->setCurrentItem( item );
}

//    TQListBox* uploadFileListBox;
TQString DistpartDialog::getuploadFileListBoxText() {
    return  uploadFileListBox->currentText();
}

int DistpartDialog::getuploadFileListBoxItem() {
    return  uploadFileListBox->currentItem();
}

void DistpartDialog::setuploadFileListBoxItem(int item) {
     uploadFileListBox->setCurrentItem( item);
}

//    TQListBox* srcDistFileListBox;
TQString DistpartDialog::getsrcDistFileListBoxText() {
    return  srcDistFileListBox->currentText ();
}

int DistpartDialog::getsrcDistFileListBoxItem() {
    return  srcDistFileListBox->currentItem ();
}

void DistpartDialog::setsrcDistFileListBoxItem(int item) {
     srcDistFileListBox->setCurrentItem( item );
}

//    TQMultiLineEdit* projectDescriptionMultilineEdit;
TQString DistpartDialog::getprojectDescriptionMultilineEditText() {
    return  projectDescriptionMultilineEdit->text();
}

void DistpartDialog::setprojectDescriptionMultilineEditText(TQString text) {
     projectDescriptionMultilineEdit->setText(text);
}

TQString DistpartDialog::getprojectChangelogMultilineEditText() {
    return  projectChangelogMultilineEdit->text();
}

void DistpartDialog::setprojectChangelogMultilineEditText(TQString text) {
     projectChangelogMultilineEdit->setText(text);
}

TQString DistpartDialog::getSourceName() {
    TQString name = (getcustomProjectCheckBoxState()) ? getarchNameFormatLineEditText() : TQString("%n-%v");
    name += (getcustomProjectCheckBoxState() && getbzipCheckBoxState()) ? ".tar.bz2" : ".tar.gz";
    return name.replace(TQRegExp("%n"),getappNameFormatLineEditText())
	.replace(TQRegExp("%v"),getversionLineEditText())
	.replace(TQRegExp("%d"),TQDate::currentDate().toString("yyyyMMdd"));
}

void DistpartDialog::loadSettings() {
    TQDomDocument &dom = *m_part->projectDom();

     srcDistFileListBox->insertStringList( m_part->project()->distFiles() );

    // First Tab
    setcustomProjectCheckBoxState(DomUtil::readBoolEntry(dom,"/dist/custom",false));
    slotcustomProjectCheckBoxChanged();
    setbzipCheckBoxState(DomUtil::readBoolEntry(dom,"/dist/bzip",false));
    setarchNameFormatLineEditText(DomUtil::readEntry(dom,"/dist/archname"));


    // Second Tab
    setappNameFormatLineEditText(DomUtil::readEntry(dom,"/dist/appname", m_part->project()->projectName() ));
    setversionLineEditText(DomUtil::readEntry(dom,"/dist/version",DomUtil::readEntry(dom,"/general/version")));
    setreleaseLineEditText(DomUtil::readEntry(dom,"/dist/release"));
    setvendorLineEditText(DomUtil::readEntry(dom,"/dist/vendor"));
    setlicenseLineEditText(DomUtil::readEntry(dom,"/dist/licence"));
    setsummaryLineEditText(DomUtil::readEntry(dom,"/dist/summary"));
    setgroupLineEditText(DomUtil::readEntry(dom,"/dist/group"));
    setpackagerLineEditText(DomUtil::readEntry(dom,"/dist/packager"));
    setprojectDescriptionMultilineEditText(DomUtil::readEntry(dom,"/dist/description",DomUtil::readEntry(dom,"/general/description")));
    setprojectChangelogMultilineEditText(DomUtil::readEntry(dom,"/dist/changelog"));
    setdevPackageCheckBoxState(DomUtil::readBoolEntry(dom,"/dist/devpackage"));
    setdocsPackageCheckBoxState(DomUtil::readBoolEntry(dom,"/dist/docspackage"));
    setappIconCheckBoxState(DomUtil::readBoolEntry(dom,"/dist/appicon"));
    setarchComboBoxItem(DomUtil::readIntEntry(dom,"/dist/arch"));

    // Third Tab
    setgenHTMLCheckBoxState(DomUtil::readBoolEntry(dom,"/dist/genHTML"));
    setuseRPMInfoCheckBoxState(DomUtil::readBoolEntry(dom,"/dist/useRPM"));
    setuploadftpkdeorgCheckBoxState(DomUtil::readBoolEntry(dom,"/dist/ftpkde"));
    setuploadAppsKDEcomCheckBoxState(DomUtil::readBoolEntry(dom,"/dist/appskde"));
    setuploadCustomCheckBoxState(DomUtil::readBoolEntry(dom,"/dist/custom"));
    slotuploadCustomCheckBoxChanged();
    setuploadURLLineEditText(DomUtil::readEntry(dom,"/dist/url"));
}

void DistpartDialog::storeSettings() {
    TQDomDocument &dom = *m_part->projectDom();

    // First Tab
    DomUtil::writeBoolEntry(dom,"/dist/custom",getcustomProjectCheckBoxState());
    DomUtil::writeBoolEntry(dom,"/dist/bzip",getbzipCheckBoxState());
    DomUtil::writeEntry(dom,"/dist/archname",getarchNameFormatLineEditText());

    // Second Tab
    DomUtil::writeEntry(dom,"/dist/appname",getappNameFormatLineEditText());
    DomUtil::writeEntry(dom,"/dist/version",getversionLineEditText());
    DomUtil::writeEntry(dom,"/dist/release",getreleaseLineEditText());
    DomUtil::writeEntry(dom,"/dist/vendor",getvendorLineEditText());
    DomUtil::writeEntry(dom,"/dist/licence",getlicenseLineEditText());
    DomUtil::writeEntry(dom,"/dist/summary",getsummaryLineEditText());
    DomUtil::writeEntry(dom,"/dist/group",getgroupLineEditText());
    DomUtil::writeEntry(dom,"/dist/packager",getpackagerLineEditText());
    DomUtil::writeEntry(dom,"/dist/description",getprojectDescriptionMultilineEditText());
    DomUtil::writeEntry(dom,"/dist/changelog",getprojectChangelogMultilineEditText());
    DomUtil::writeBoolEntry(dom,"/dist/devpackage",getdevPackageCheckBoxState());
    DomUtil::writeBoolEntry(dom,"/dist/docspackage",getdocsPackageCheckBoxState());
    DomUtil::writeBoolEntry(dom,"/dist/appicon",getappIconCheckBoxState());
    DomUtil::writeIntEntry(dom,"/dist/arch",getarchComboBoxItem());

    // Third Tab
    DomUtil::writeBoolEntry(dom,"/dist/genHTML",getgenHTMLCheckBoxState());
    DomUtil::writeBoolEntry(dom,"/dist/useRPM",getuseRPMInfoCheckBoxState());
    DomUtil::writeBoolEntry(dom,"/dist/ftpkde",getuploadftpkdeorgCheckBoxState());
    DomUtil::writeBoolEntry(dom,"/dist/appskde",getuploadAppsKDEcomCheckBoxState());
    DomUtil::writeBoolEntry(dom,"/dist/custom",getuploadCustomCheckBoxState());
    DomUtil::writeEntry(dom,"/dist/url",getuploadURLLineEditText());
}
// Populate Spec Data from UI;
void DistpartDialog::setPackageData()
{
	m_spec->setAppRevision(  releaseLineEdit->text());
	m_spec->setAppName(  appNameLineEdit->text());
	m_spec->setAppVendor(  vendorLineEdit->text());
	m_spec->setAppLicense(  licenseLineEdit->text());
	m_spec->setAppSummary(  summaryLineEdit->text());
	m_spec->setAppPackager(  packagerLineEdit->text());
	m_spec->setAppVersion(  versionLineEdit->text());
	m_spec->setAppGroup(  groupLineEdit->text());
	m_spec->setAppDescription(  projectDescriptionMultilineEdit->text());
	m_spec->setAppChangelog(  projectChangelogMultilineEdit->text());
}
// Populate UI from Spec data;
void DistpartDialog::getPackageData()
{
	 releaseLineEdit->setText(m_spec->getAppRevision());
	 appNameLineEdit->setText(m_spec->getAppName());
	 vendorLineEdit->setText(m_spec->getAppVendor());
	 licenseLineEdit->setText(m_spec->getAppLicense( ));
	 summaryLineEdit->setText(m_spec->getAppSummary( ));
	 packagerLineEdit->setText(m_spec->getAppPackager( ));
	 versionLineEdit->setText(m_spec->getAppVersion());
	 groupLineEdit->setText(m_spec->getAppGroup( ));
	 projectDescriptionMultilineEdit->setText(m_spec->getAppDescription( ));
	 projectChangelogMultilineEdit->setText(m_spec->getAppChangelog( ));
}
void DistpartDialog::slotbuildAllPushButtonPressed( )
{
	setPackageData();
	m_spec->slotbuildAllPushButtonPressed();
}

void DistpartDialog::slotexportSPECPushButtonPressed( )
{
	setPackageData();
	m_spec->slotexportSPECPushButtonPressed();
}

void DistpartDialog::slotimportSPECPushButtonPressed( )
{
	m_spec->slotimportSPECPushButtonPressed();
	getPackageData();
}

void DistpartDialog::slotsrcPackagePushButtonPressed( )
{
	setPackageData();
	m_spec->slotsrcPackagePushButtonPressed();
}


void DistpartDialog::slotAddFileButtonPressed(){
	TQStringList filenames = KFileDialog::getOpenFileNames();
	for(uint count =0; count< filenames.size(); count++){
		TQString base = m_part->project()->projectDirectory() +"/";
		srcDistFileListBox->insertItem(filenames[count].remove(base));
	}
}

void DistpartDialog::slotRemoveFile(TQListBoxItem *item){
	if ( KMessageBox::Yes == KMessageBox::warningYesNo( this, i18n("Remove %1").arg( item->text() ), i18n("Remove File") )){
	for(uint count =0; count< srcDistFileListBox->numRows(); count++){
		if ( item == srcDistFileListBox->item(count)){
			srcDistFileListBox->removeItem(count);
			break;
		}
	}
	}
}

#include "distpart_widget.moc"
