/***************************************************************************
 *   Copyright (C) 2003 by KDevelop Authors                                *
 *   tdevelop-devel@kde.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqlayout.h>
#include <tqframe.h>
#include <tqdir.h>

#include <tdeparts/part.h>
#include <klibloader.h>
#include <kurl.h>
#include <kdebug.h>
#include <tdeapplication.h>
#include <tdeconfig.h>

#include "kdevcore.h"
#include "kdevproject.h"
#include "konsoleviewpart.h"
#include "kdevpartcontroller.h"

#include "konsoleviewwidget.h"

KonsoleViewWidget::KonsoleViewWidget(KonsoleViewPart *part)
 : TQWidget(0, "konsole widget"), part(0), owner( part )
{
    connect(part->partController(), TQT_SIGNAL(activePartChanged(KParts::Part*)), this, TQT_SLOT(activePartChanged(KParts::Part*)));
    vbox = new TQVBoxLayout(this);
}

KonsoleViewWidget::~KonsoleViewWidget()
{
}

void KonsoleViewWidget::show()
{
    activate();
    TQWidget::show();
}

void KonsoleViewWidget::activate()
{
    kdDebug(9035) << k_funcinfo << endl;
    if (part)
        return;

    KLibFactory *factory = KLibLoader::self()->factory("libkonsolepart");
    if (!factory)
        return;

    part = (KParts::ReadOnlyPart *) factory->create(this);
    if (!part)
        return;

    part->widget()->setFocusPolicy(TQ_WheelFocus);
    setFocusProxy(part->widget());
    part->widget()->setFocus();

    if (part->widget()->inherits(TQFRAME_OBJECT_NAME_STRING))
        ((TQFrame*)part->widget())->setFrameStyle(TQFrame::Panel|TQFrame::Sunken);

    vbox->addWidget(part->widget());

//    this->activePartChanged( owner->partController()->activePart() );
    part->widget()->show();

    connect(part, TQT_SIGNAL(destroyed()), this, TQT_SLOT(partDestroyed()));
}


void KonsoleViewWidget::activePartChanged(KParts::Part *activatedPart)
{
    kdDebug(9035) << k_funcinfo << endl;
    KParts::ReadOnlyPart *ro_part = dynamic_cast<KParts::ReadOnlyPart*>(activatedPart);

    if (ro_part && !ro_part->url().isLocalFile())
    {
        kdDebug(9035) << k_funcinfo << "part is null or not local" << endl;
        return;
    }
    TQString dir;
    if (ro_part)
        dir = ro_part->url().directory();
    else if (owner->project())
        dir = owner->project()->projectDirectory();

    kdDebug(9035) << k_funcinfo "Changing dir to " << dir << endl;
    if (dir.isEmpty())
        return;
    setDirectory( KURL(dir) );
}

void KonsoleViewWidget::setDirectory(const KURL &dirUrl)
{
    kdDebug(9035) << k_funcinfo << "part is " << (long)part << endl;

    if (part && dirUrl != part->url())
    {
        kdDebug(9035) << k_funcinfo << "Changing dirUrl.path() == " << dirUrl.path() << endl;
        kdDebug(9035) << k_funcinfo << "Changing part->url.path() == " << part->url().path() << endl;
        TDEConfig* config = kapp->config();
        
        kdDebug(9035) << k_funcinfo << "SyncTerminalEmulator: " << config->readBoolEntry("SyncTerminalEmulator") << endl;

        if (config->readBoolEntry("SyncTerminalEmulator")) {
            part->openURL( dirUrl );
        }
    }
}

void KonsoleViewWidget::partDestroyed()
{
    part = 0;
    activate();
}


#include "konsoleviewwidget.moc"
