/***************************************************************************
 *   Copyright (C) 2003 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __REPLACEVIEW_H__
#define __REPLACEVIEW_H__

#include <tdelistview.h>

#include <tqstring.h>
#include <tqregexp.h>

class TQTextStream;
class TQWidget;
class ReplaceItem;

class ReplaceView : public TDEListView
{
    Q_OBJECT
  

signals:
    void editDocument( const TQString &, int );

public:
    ReplaceView( TQWidget *);
    ReplaceItem * firstChild() const;
    void setReplacementData( TQRegExp const &, TQString const & );
    void showReplacementsForFile( TQTextStream &, TQString const & );
    void makeReplacementsForFile( TQTextStream & istream, TQTextStream & ostream, ReplaceItem const * fileitem );

private slots:
    void slotMousePressed(int, TQListViewItem *, const TQPoint &, int);
    void slotClicked( TQListViewItem * );

private:
    TQRegExp _regexp;
    TQString _replacement;
    ReplaceItem * _latestfile;

friend class ReplaceItem;

};




#endif
