#ifndef __EDITORPROXY_H__
#define __EDITORPROXY_H__


#include <tqobject.h>
#include <tqmemarray.h>
#include <tqguardedptr.h>

class TQPopupMenu;
class MultiBuffer;
class TQTimer;

#include <tdeparts/part.h>
#include <tdetexteditor/markinterface.h>
#include <tdeversion.h>
# include <tdetexteditor/markinterfaceextension.h>

class EditorProxy : public TQObject
{
  Q_OBJECT
  

public:

  static EditorProxy *getInstance();

  void setLineNumber(KParts::Part *part, int lineNum, int col);

  void installPopup(KParts::Part *part);

  void registerEditor(MultiBuffer* wrapper);
  void deregisterEditor(MultiBuffer* wrapper);

  TQWidget * widgetForPart( KParts::Part * part );
  TQWidget * topWidgetForPart( KParts::Part * part );

  bool isDelayedViewCapable();

  TQWidget * findPartWidget( KParts::Part * part );

public slots:
  void setLineNumberDelayed();

private slots:

  void popupAboutToShow();
  void showPopup();

private:

  EditorProxy();

  static EditorProxy *s_instance;

  TQMemArray<int> m_popupIds;

  // This list is used to save line/col information for not yet activated editor views.
  TQValueList< MultiBuffer* > m_editorParts;

  TQTimer* m_delayedLineTimer;
  bool m_delayedViewCreationCompatibleUI;
  KParts::Part *m_delayedPart;
  int m_delayedLine;
  int m_delayedCol;
};


#endif
