/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_EXECEXTERNALFETCHER_H
#define TELLICO_EXECEXTERNALFETCHER_H

#include "fetcher.h"
#include "configwidget.h"
#include "../datavectors.h"

#include <tqintdict.h>

class TDEProcess;
class KURLRequester;
class KLineEdit;
class KComboBox;

class TQCheckBox;

namespace Tellico {
  namespace GUI {
    class ComboBox;
    class LineEdit;
    class CollectionTypeCombo;
  }
  namespace Fetch {

/**
 * @author Robby Stephenson
 */
class ExecExternalFetcher : public Fetcher {
TQ_OBJECT
  

public:
  ExecExternalFetcher(TQObject* parent, const char* name=0);
  /**
   */
  virtual ~ExecExternalFetcher();

  virtual TQString source() const;
  virtual bool isSearching() const { return m_started; }
  virtual bool canSearch(FetchKey k) const { return m_args.contains(k); }
  virtual bool canUpdate() const { return m_canUpdate; }
  virtual void search(FetchKey key, const TQString& value);
  virtual void updateEntry(Data::EntryPtr entry);
  virtual void stop();
  virtual Data::EntryPtr fetchEntry(uint uid);
  virtual Type type() const { return ExecExternal; }
  virtual bool canFetch(int type) const;
  virtual void readConfigHook(const TDEConfigGroup& config);
  virtual Fetch::ConfigWidget* configWidget(TQWidget* parent) const;

  const TQString& execPath() const { return m_path; }

  class ConfigWidget : public Fetch::ConfigWidget {
  public:
    ConfigWidget(TQWidget* parent = 0, const ExecExternalFetcher* fetcher = 0);
    ~ConfigWidget();

    void readConfig(TDEConfig* config);
    virtual void saveConfig(TDEConfigGroup& config);
    virtual void removed();
    virtual TQString preferredName() const;

  private:
    bool m_deleteOnRemove : 1;
    TQString m_name, m_newStuffName;
    KURLRequester* m_pathEdit;
    GUI::CollectionTypeCombo* m_collCombo;
    GUI::ComboBox* m_formatCombo;
    TQIntDict<TQCheckBox> m_cbDict;
    TQIntDict<GUI::LineEdit> m_leDict;
    TQCheckBox* m_cbUpdate;
    GUI::LineEdit* m_leUpdate;
  };
  friend class ConfigWidget;

  static TQString defaultName();

private slots:
  void slotData(TDEProcess* proc, char* buffer, int len);
  void slotError(TDEProcess* proc, char* buffer, int len);
  void slotProcessExited(TDEProcess* proc);

private:
  static TQStringList parseArguments(const TQString& str);

  void startSearch(const TQStringList& args);

  bool m_started;
  int m_collType;
  int m_formatType;
  TQString m_path;
  TQMap<FetchKey, TQString> m_args;
  bool m_canUpdate : 1;
  TQString m_updateArgs;
  TDEProcess* m_process;
  TQByteArray m_data;
  TQMap<int, Data::EntryPtr> m_entries; // map from search result id to entry
  TQStringList m_errors;
  bool m_deleteOnRemove : 1;
  TQString m_newStuffName;
};

  } // end namespace
} // end namespace

#endif
