/***************************************************************************
    copyright            : (C) 2008 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_IMPORT_XMLSTATEHANDLER_H
#define TELLICO_IMPORT_XMLSTATEHANDLER_H

#ifdef TQT_NO_CAST_ASCII
#define HAD_TQT_NO_CAST_ASCII
#undef TQT_NO_CAST_ASCII
#endif

#include <tqxml.h>

#ifdef HAD_TQT_NO_CAST_ASCII
#define TQT_NO_CAST_ASCII
#undef HAD_TQT_NO_CAST_ASCII
#endif

#include "../datavectors.h"

namespace Tellico {
  namespace Import {
    namespace SAX {

class StateData {
public:
  TQString text;
  TQString error;
  TQString ns; // namespace
  TQString textBuffer;
  uint syntaxVersion;
  TQString collTitle;
  int collType;
  TQString entryName;
  Data::CollPtr coll;
  Data::FieldVec fields;
  Data::FieldPtr currentField;
  Data::EntryVec entries;
  FilterPtr filter;
  Data::BorrowerPtr borrower;
  bool defaultFields;
  bool loadImages;
  bool hasImages;
};

class StateHandler {
public:
  StateHandler(StateData* data) : d(data) {}
  virtual ~StateHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&) = 0;
  virtual bool   end(const TQString&, const TQString&, const TQString&) = 0;

  StateHandler* nextHandler(const TQString&, const TQString&, const TQString&);
protected:
  StateData* d;
private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&)  { return 0; }
};

class NullHandler : public StateHandler {
public:
  NullHandler(StateData* data) : StateHandler(data) {}
  virtual ~NullHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&) { return true; }
  virtual bool   end(const TQString&, const TQString&, const TQString&) { return true; }
};

class RootHandler : public StateHandler {
public:
  RootHandler(StateData* data) : StateHandler(data) {}
  virtual ~RootHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&) { return true; }
  virtual bool   end(const TQString&, const TQString&, const TQString&) { return true; }

private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&);
};

class DocumentHandler : public StateHandler {
public:
  DocumentHandler(StateData* data) : StateHandler(data) {}
  virtual ~DocumentHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&);
};

class CollectionHandler : public StateHandler {
public:
  CollectionHandler(StateData* data) : StateHandler(data) {}
  virtual ~CollectionHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&);
};

class FieldsHandler : public StateHandler {
public:
  FieldsHandler(StateData* data) : StateHandler(data) {}
  virtual ~FieldsHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&);
};

class FieldHandler : public StateHandler {
public:
  FieldHandler(StateData* data) : StateHandler(data) {}
  virtual ~FieldHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&);
};

class FieldPropertyHandler : public StateHandler {
public:
  FieldPropertyHandler(StateData* data) : StateHandler(data) {}
  virtual ~FieldPropertyHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  TQString m_propertyName;
};

class BibtexPreambleHandler : public StateHandler {
public:
  BibtexPreambleHandler(StateData* data) : StateHandler(data) {}
  virtual ~BibtexPreambleHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);
};

class BibtexMacrosHandler : public StateHandler {
public:
  BibtexMacrosHandler(StateData* data) : StateHandler(data) {}
  virtual ~BibtexMacrosHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&);
};

class BibtexMacroHandler : public StateHandler {
public:
  BibtexMacroHandler(StateData* data) : StateHandler(data) {}
  virtual ~BibtexMacroHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  TQString m_macroName;
};

class EntryHandler : public StateHandler {
public:
  EntryHandler(StateData* data) : StateHandler(data) {}
  virtual ~EntryHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&);
};

class FieldValueContainerHandler : public StateHandler {
public:
  FieldValueContainerHandler(StateData* data) : StateHandler(data) {}
  virtual ~FieldValueContainerHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&);
};

class FieldValueHandler : public StateHandler {
public:
  FieldValueHandler(StateData* data) : StateHandler(data) {}
  virtual ~FieldValueHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&);
  bool m_i18n;
  bool m_validateISBN;
};

class DateValueHandler : public StateHandler {
public:
  DateValueHandler(StateData* data) : StateHandler(data) {}
  virtual ~DateValueHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);
};

class TableColumnHandler : public StateHandler {
public:
  TableColumnHandler(StateData* data) : StateHandler(data) {}
  virtual ~TableColumnHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);
};

class ImagesHandler : public StateHandler {
public:
  ImagesHandler(StateData* data) : StateHandler(data) {}
  virtual ~ImagesHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&);
};

class ImageHandler : public StateHandler {
public:
  ImageHandler(StateData* data) : StateHandler(data) {}
  virtual ~ImageHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  TQString m_format;
  bool m_link;
  TQString m_imageId;
  int m_width;
  int m_height;
};

class FiltersHandler : public StateHandler {
public:
  FiltersHandler(StateData* data) : StateHandler(data) {}
  virtual ~FiltersHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&);
};

class FilterHandler : public StateHandler {
public:
  FilterHandler(StateData* data) : StateHandler(data) {}
  virtual ~FilterHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&);
};

class FilterRuleHandler : public StateHandler {
public:
  FilterRuleHandler(StateData* data) : StateHandler(data) {}
  virtual ~FilterRuleHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);
};

class BorrowersHandler : public StateHandler {
public:
  BorrowersHandler(StateData* data) : StateHandler(data) {}
  virtual ~BorrowersHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&);
};

class BorrowerHandler : public StateHandler {
public:
  BorrowerHandler(StateData* data) : StateHandler(data) {}
  virtual ~BorrowerHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  virtual StateHandler* nextHandlerImpl(const TQString&, const TQString&, const TQString&);
};

class LoanHandler : public StateHandler {
public:
  LoanHandler(StateData* data) : StateHandler(data) {}
  virtual ~LoanHandler() {}

  virtual bool start(const TQString&, const TQString&, const TQString&, const TQXmlAttributes&);
  virtual bool   end(const TQString&, const TQString&, const TQString&);

private:
  int m_id;
  TQString m_uid;
  TQString m_loanDate;
  TQString m_dueDate;
  bool m_inCalendar;
};

    }
  }
}
#endif
