/***************************************************************************
    copyright            : (C) 2007 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_FETCH_ARXIVFETCHER_H
#define TELLICO_FETCH_ARXIVFETCHER_H

#include "fetcher.h"
#include "configwidget.h"
#include "../datavectors.h"

#include <tdeio/job.h>

#include <tqcstring.h> // for TQByteArray
#include <tqguardedptr.h>

namespace Tellico {

  class XSLTHandler;

  namespace Fetch {

/**
 * @author Robby Stephenson
 */
class ArxivFetcher : public Fetcher {
TQ_OBJECT
  

public:
  ArxivFetcher(TQObject* parent);
  ~ArxivFetcher();

  virtual TQString source() const;
  virtual bool isSearching() const { return m_started; }
  virtual void search(FetchKey key, const TQString& value);
  virtual void continueSearch();

  virtual bool canSearch(FetchKey k) const { return k == Title || k == Person || k == Keyword || k == ArxivID; }
  virtual void stop();
  virtual Data::EntryPtr fetchEntry(uint uid);
  virtual Type type() const { return Arxiv; }
  virtual bool canFetch(int type) const;
  virtual void readConfigHook(const TDEConfigGroup& config);

  virtual void updateEntry(Data::EntryPtr entry);
  virtual void updateEntrySynchronous(Data::EntryPtr entry);

  virtual Fetch::ConfigWidget* configWidget(TQWidget* parent) const;

  class ConfigWidget : public Fetch::ConfigWidget {
  public:
    ConfigWidget(TQWidget* parent_, const ArxivFetcher* fetcher = 0);
    virtual void saveConfig(TDEConfigGroup& config);
    virtual TQString preferredName() const;
  };
  friend class ConfigWidget;

  static TQString defaultName();

private slots:
  void slotData(TDEIO::Job* job, const TQByteArray& data);
  void slotComplete(TDEIO::Job* job);

private:
  void initXSLTHandler();
  KURL searchURL(FetchKey key, const TQString& value) const;
  void doSearch();

  XSLTHandler* m_xsltHandler;
  int m_start;
  int m_total;

  TQByteArray m_data;
  TQMap<int, Data::EntryPtr> m_entries;
  TQGuardedPtr<TDEIO::Job> m_job;

  FetchKey m_key;
  TQString m_value;
  bool m_started;
};

  }
}
#endif
