// This module defines interface to the TQextScintillaAPIs class.
//
// Copyright (c) 2006
// 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
// 
// This file is part of TQScintilla.
// 
// This copy of TQScintilla is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// TQScintilla is supplied in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
// 
// You should have received a copy of the GNU General Public License along with
// TQScintilla; see the file LICENSE.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


#ifndef TQEXTSCINTILLAAPIS_H
#define TQEXTSCINTILLAAPIS_H


#include <tqstringlist.h>

#include <tqextscintillaglobal.h>


//! \brief The TQextScintillaAPIs class represents the textual API information
//! used in call tips and for auto-completion.
//!
//! API information is read from one or more files.  Each API function is
//! described by a single line of text comprising the function's name, followed
//! by the function's optional comma separated parameters enclosed in
//! parenthesis, and finally followed by optional explanatory text.
//!
//! A function name may be followed by a `?' and a number.  The number is used
//! by auto-completion to display a registered TQPixmap with the function name.
//!
//! All function names are used by auto-completion, but only those that include
//! function parameters are used in call tips.
class TQEXTSCINTILLA_EXPORT TQextScintillaAPIs
{
public:
	//! Constructs a TQextScintillaAPIs instance.
	TQextScintillaAPIs();

	//! Destroys the TQextScintillaAPIs instance.
	~TQextScintillaAPIs();

	//! Add the single API entry \a entry to the current set.
	void add(const TQString &entry);

	//! Load the API information from the file named \a fname, adding it to
	//! the current set.  Returns TRUE if successful, otherwise FALSE.
	bool load(const TQString &fname);

	//! Deletes all API information.
	void clear();

private:
	friend class TQextScintilla;

	void autoCompletionList(const TQString &starts, bool cs,
			TQStringList &wlist);
	TQString callTips(const TQString &function,int maxnr,int commas);
	TQString callTipsNextPrev(int dir);
	void ensureSorted();

	bool sorted;
	int ctcursor;
	TQStringList apis;
	TQStringList ctlist;

#if defined(TQ_DISABLE_COPY)
	TQextScintillaAPIs(const TQextScintillaAPIs &);
	TQextScintillaAPIs &operator=(const TQextScintillaAPIs &);
#endif
};

#endif
