// This module implements the TQextScintillaLexerJavaScript class.
//
// Copyright (c) 2006
// 	Riverbank Computing Limited <info@riverbankcomputing.co.uk>
// 
// This file is part of TQScintilla.
// 
// This copy of TQScintilla is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// TQScintilla is supplied in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
// 
// You should have received a copy of the GNU General Public License along with
// TQScintilla; see the file LICENSE.  If not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <tqcolor.h>
#include <tqfont.h>

#include "tqextscintillalexerjavascript.h"


// The list of JavaScript keywords that can be used by other friendly lexers.
const char *TQextScintillaLexerJavaScript::keywordClass =
	"abstract boolean break byte case catch char class const continue "
	"debugger default delete do double else enum export extends final "
	"finally float for function goto if implements import in instanceof "
	"int interface long native new package private protected public "
	"return short static super switch synchronized this throw throws "
	"transient try typeof var void volatile while with";


// The ctor.
TQextScintillaLexerJavaScript::TQextScintillaLexerJavaScript(TQObject *parent,const char *name)
	: TQextScintillaLexerCPP(parent,name)
{
}


// The dtor.
TQextScintillaLexerJavaScript::~TQextScintillaLexerJavaScript()
{
}


// Returns the language name.
const char *TQextScintillaLexerJavaScript::language() const
{
	return "JavaScript";
}


// Returns the foreground colour of the text for a style.
TQColor TQextScintillaLexerJavaScript::color(int style) const
{
	if (style == Regex)
		return TQColor(0x3f,0x7f,0x3f);

	return TQextScintillaLexerCPP::color(style);
}


// Returns the end-of-line fill for a style.
bool TQextScintillaLexerJavaScript::eolFill(int style) const
{
	if (style == Regex)
		return TRUE;

	return TQextScintillaLexerCPP::eolFill(style);
}


// Returns the font of the text for a style.
TQFont TQextScintillaLexerJavaScript::font(int style) const
{
	if (style == Regex)
#if defined(Q_OS_WIN)
		return TQFont("Courier New",10);
#else
		return TQFont("Bitstream Vera Sans Mono",9);
#endif

	return TQextScintillaLexerCPP::font(style);
}


// Returns the set of keywords.
const char *TQextScintillaLexerJavaScript::keywords(int set) const
{
	if (set != 1)
		return 0;

	return keywordClass;
}


// Returns the user name of a style.
TQString TQextScintillaLexerJavaScript::description(int style) const
{
	if (style == Regex)
		return tr("Regular expression");

	return TQextScintillaLexerCPP::description(style);
}


// Returns the background colour of the text for a style.
TQColor TQextScintillaLexerJavaScript::paper(int style) const
{
	if (style == Regex)
		return TQColor(0xe0,0xf0,0xff);

	return TQextScintillaLexer::paper(style);
}

#include "tqextscintillalexerjavascript.moc"
